/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder;

import com.power.common.util.FileUtil;
import com.power.doc.builder.DocBuilderTemplate;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.constants.DocGlobalConstants;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.template.SpringBootDocBuildTemplate;
import com.power.doc.utils.BeetlTemplateUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.beetl.core.Template;

public class HtmlApiDocBuilder {
    private static long now = System.currentTimeMillis();
    private static String INDEX_HTML = "index.html";
    private static final String ERROR_CODE_HTML = "error.html";
    private static final String DICT_HTML = "dict.html";

    public static void buildApiDoc(ApiConfig config) {
        JavaProjectBuilder javaProjectBuilder = new JavaProjectBuilder();
        HtmlApiDocBuilder.buildApiDoc(config, javaProjectBuilder);
    }

    public static void buildApiDoc(ApiConfig config, JavaProjectBuilder javaProjectBuilder) {
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config);
        config.setParamsDataToTree(false);
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, javaProjectBuilder);
        SpringBootDocBuildTemplate docBuildTemplate = new SpringBootDocBuildTemplate();
        List<ApiDoc> apiDocList = docBuildTemplate.getApiData(configBuilder);
        Template indexCssTemplate = BeetlTemplateUtil.getByName("AllInOne.css");
        FileUtil.nioWriteFile((String)indexCssTemplate.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + "AllInOne.css"));
        if (config.isAllInOne()) {
            if (StringUtils.isNotEmpty((CharSequence)config.getAllInOneDocFileName())) {
                INDEX_HTML = config.getAllInOneDocFileName();
            }
            if (config.isCreateDebugPage()) {
                builderTemplate.buildAllInOne(apiDocList, config, javaProjectBuilder, "debug-all.html", "debug-all.html");
                Template mockJs = BeetlTemplateUtil.getByName("js/debug.js");
                FileUtil.nioWriteFile((String)mockJs.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + "debug.js"));
            } else {
                builderTemplate.buildAllInOne(apiDocList, config, javaProjectBuilder, "AllInOne.html", INDEX_HTML);
            }
            builderTemplate.buildSearchJs(config, javaProjectBuilder, apiDocList, "js/search_all.js.btl");
        } else {
            String indexAlias;
            if (config.isCreateDebugPage()) {
                indexAlias = "debug";
                HtmlApiDocBuilder.buildDoc(builderTemplate, apiDocList, config, javaProjectBuilder, "html/debug.html", indexAlias);
                Template mockJs = BeetlTemplateUtil.getByName("js/debug.js");
                FileUtil.nioWriteFile((String)mockJs.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + "debug.js"));
            } else {
                indexAlias = "api";
                HtmlApiDocBuilder.buildDoc(builderTemplate, apiDocList, config, javaProjectBuilder, "html/index.html", indexAlias);
            }
            builderTemplate.buildErrorCodeDoc(config, javaProjectBuilder, apiDocList, "html/error.html", ERROR_CODE_HTML, indexAlias);
            builderTemplate.buildDirectoryDataDoc(config, javaProjectBuilder, apiDocList, "html/dict.html", DICT_HTML, indexAlias);
            builderTemplate.buildSearchJs(config, javaProjectBuilder, apiDocList, "js/search.js.btl");
        }
    }

    private static void buildDoc(DocBuilderTemplate builderTemplate, List<ApiDoc> apiDocList, ApiConfig config, JavaProjectBuilder javaProjectBuilder, String template, String indexHtml) {
        FileUtil.mkdirs((String)config.getOutPath());
        int index = 0;
        for (ApiDoc doc : apiDocList) {
            if (index == 0) {
                doc.setAlias(indexHtml);
            }
            builderTemplate.buildDoc(apiDocList, config, javaProjectBuilder, template, doc.getAlias() + ".html", doc, indexHtml);
            ++index;
        }
    }
}

