/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.power.common.util.FileUtil;
import com.power.common.util.StringUtil;
import com.power.doc.builder.DocBuilderTemplate;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.model.ApiMethodDoc;
import com.power.doc.model.ApiParam;
import com.power.doc.model.ApiReqHeader;
import com.power.doc.model.postman.InfoBean;
import com.power.doc.model.postman.ItemBean;
import com.power.doc.model.postman.RequestItem;
import com.power.doc.model.postman.UrlBean;
import com.power.doc.model.postman.request.ParamBean;
import com.power.doc.model.postman.request.RequestBean;
import com.power.doc.model.postman.request.body.BodyBean;
import com.power.doc.model.postman.request.header.HeaderBean;
import com.power.doc.template.SpringBootDocBuildTemplate;
import com.power.doc.utils.PathUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class PostmanJsonBuilder {
    private static final String MSG = "Interface name is not set.";

    public static void buildPostmanCollection(ApiConfig config) {
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config);
        JavaProjectBuilder javaProjectBuilder = new JavaProjectBuilder();
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, javaProjectBuilder);
        PostmanJsonBuilder.postManCreate(config, configBuilder);
    }

    public static void buildPostmanCollection(ApiConfig config, JavaProjectBuilder projectBuilder) {
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config);
        config.setParamsDataToTree(false);
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, projectBuilder);
        PostmanJsonBuilder.postManCreate(config, configBuilder);
    }

    private static ItemBean buildItemBean(ApiDoc apiDoc) {
        ItemBean itemBean = new ItemBean();
        itemBean.setName(StringUtil.isEmpty((String)apiDoc.getDesc()) ? MSG : apiDoc.getDesc());
        ArrayList<ItemBean> itemBeans = new ArrayList<ItemBean>();
        List<ApiMethodDoc> apiMethodDocs = apiDoc.getList();
        apiMethodDocs.forEach(apiMethodDoc -> {
            ItemBean itemBean1 = PostmanJsonBuilder.buildItem(apiMethodDoc);
            itemBeans.add(itemBean1);
        });
        itemBean.setItem(itemBeans);
        return itemBean;
    }

    private static ItemBean buildItem(ApiMethodDoc apiMethodDoc) {
        ItemBean item = new ItemBean();
        RequestBean requestBean = new RequestBean();
        item.setName(StringUtil.isEmpty((String)apiMethodDoc.getDesc()) ? MSG : apiMethodDoc.getDesc());
        item.setDescription(apiMethodDoc.getDetail());
        requestBean.setDescription(apiMethodDoc.getDesc());
        requestBean.setMethod(apiMethodDoc.getType());
        requestBean.setHeader(PostmanJsonBuilder.buildHeaderBeanList(apiMethodDoc));
        requestBean.setBody(PostmanJsonBuilder.buildBodyBean(apiMethodDoc));
        requestBean.setUrl(PostmanJsonBuilder.buildUrlBean(apiMethodDoc));
        item.setRequest(requestBean);
        return item;
    }

    private static UrlBean buildUrlBean(ApiMethodDoc apiMethodDoc) {
        UrlBean urlBean = new UrlBean();
        String url = apiMethodDoc.getRequestExample().getUrl() == null ? apiMethodDoc.getUrl() : apiMethodDoc.getRequestExample().getUrl();
        urlBean.setRaw(PathUtil.toPostmanPath(url));
        try {
            URL url1 = new URL(apiMethodDoc.getServerUrl());
            urlBean.setPort(String.valueOf(url1.getPort()));
            ArrayList<String> hosts = new ArrayList<String>();
            hosts.add(url1.getHost());
            urlBean.setHost(hosts);
        }
        catch (MalformedURLException url1) {
            // empty catch block
        }
        String shortUrl = PathUtil.toPostmanPath(apiMethodDoc.getPath());
        String[] paths = shortUrl.split("/");
        ArrayList<String> pathList = new ArrayList<String>();
        for (String str : paths) {
            if (!StringUtil.isNotEmpty((String)str)) continue;
            pathList.add(str);
        }
        if (shortUrl.endsWith("/")) {
            pathList.add("");
        }
        urlBean.setPath(pathList);
        ArrayList<ParamBean> queryParams = new ArrayList<ParamBean>();
        for (ApiParam apiParam : apiMethodDoc.getQueryParams()) {
            ParamBean queryParam = new ParamBean();
            queryParam.setDescription(apiParam.getDesc());
            queryParam.setKey(apiParam.getField());
            queryParam.setValue(apiParam.getValue());
            queryParams.add(queryParam);
        }
        ArrayList<ParamBean> variables = new ArrayList<ParamBean>();
        for (ApiParam apiParam : apiMethodDoc.getPathParams()) {
            ParamBean queryParam = new ParamBean();
            queryParam.setDescription(apiParam.getDesc());
            queryParam.setKey(apiParam.getField());
            queryParam.setValue(apiParam.getValue());
            variables.add(queryParam);
        }
        urlBean.setVariable(variables);
        urlBean.setQuery(queryParams);
        return urlBean;
    }

    private static BodyBean buildBodyBean(ApiMethodDoc apiMethodDoc) {
        BodyBean bodyBean;
        if (apiMethodDoc.getContentType().contains("application/json; charset=utf-8")) {
            bodyBean = new BodyBean(false);
            bodyBean.setMode("raw");
            if (apiMethodDoc.getRequestExample() != null) {
                bodyBean.setRaw(apiMethodDoc.getRequestExample().getJsonBody());
            }
        } else {
            bodyBean = new BodyBean(true);
            bodyBean.setMode("formdata");
            bodyBean.setFormdata(apiMethodDoc.getRequestExample().getFormDataList());
        }
        return bodyBean;
    }

    private static List<HeaderBean> buildHeaderBeanList(ApiMethodDoc apiMethodDoc) {
        ArrayList<HeaderBean> headerBeans = new ArrayList<HeaderBean>();
        List<ApiReqHeader> headers = apiMethodDoc.getRequestHeaders();
        headers.forEach(apiReqHeader -> {
            HeaderBean headerBean = new HeaderBean();
            headerBean.setKey(apiReqHeader.getName());
            headerBean.setName(apiReqHeader.getName());
            headerBean.setValue(apiReqHeader.getValue());
            headerBean.setDisabled(!apiReqHeader.isRequired());
            headerBean.setDescription(apiReqHeader.getDesc());
            headerBeans.add(headerBean);
        });
        return headerBeans;
    }

    private static void postManCreate(ApiConfig config, ProjectDocConfigBuilder configBuilder) {
        SpringBootDocBuildTemplate docBuildTemplate = new SpringBootDocBuildTemplate();
        List<ApiDoc> apiDocList = docBuildTemplate.getApiData(configBuilder);
        RequestItem requestItem = new RequestItem();
        requestItem.setInfo(new InfoBean(config.getProjectName()));
        ArrayList<ItemBean> itemBeans = new ArrayList<ItemBean>();
        apiDocList.forEach(apiDoc -> {
            ItemBean itemBean = PostmanJsonBuilder.buildItemBean(apiDoc);
            itemBeans.add(itemBean);
        });
        requestItem.setItem(itemBeans);
        String filePath = config.getOutPath();
        filePath = filePath + "/postman.json";
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String data = gson.toJson((Object)requestItem);
        FileUtil.nioWriteFile((String)data, (String)filePath);
    }
}

