/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.utils;

import com.power.common.util.StringUtil;
import com.power.doc.filter.ReturnTypeProcessor;
import com.power.doc.model.ApiReturn;
import com.power.doc.utils.JavaClassValidateUtil;
import java.util.ArrayList;
import java.util.Stack;

public class DocClassUtil {
    public static String[] getSimpleGicName(String returnType) {
        if (JavaClassValidateUtil.isArray(returnType)) {
            returnType = returnType.substring(0, returnType.lastIndexOf("["));
            returnType = "java.util.List<" + returnType + ">";
        }
        if (returnType.contains("<")) {
            String pre = returnType.substring(0, returnType.indexOf("<"));
            if (JavaClassValidateUtil.isMap(pre)) {
                return DocClassUtil.getMapKeyValueType(returnType);
            }
            String type = returnType.substring(returnType.indexOf("<") + 1, returnType.lastIndexOf(">"));
            if (JavaClassValidateUtil.isCollection(pre)) {
                return type.split(" ");
            }
            String[] arr = type.split(",");
            return DocClassUtil.classNameFix(arr);
        }
        return new String[0];
    }

    public static String getSimpleName(String gicName) {
        if (gicName.contains("<")) {
            return gicName.substring(0, gicName.indexOf("<"));
        }
        return gicName;
    }

    private static String[] classNameFix(String[] arr) {
        ArrayList<String> classes = new ArrayList<String>();
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        int globIndex = 0;
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            if (classes.size() > 0) {
                int index = classes.size() - 1;
                if (!DocClassUtil.isClassName((String)classes.get(index))) {
                    if (++globIndex >= length) continue;
                    indexList.add(globIndex);
                    String className = (String)classes.get(index) + "," + arr[globIndex];
                    classes.set(index, className);
                    continue;
                }
                if (++globIndex >= length) continue;
                if (DocClassUtil.isClassName(arr[globIndex])) {
                    indexList.add(globIndex);
                    classes.add(arr[globIndex]);
                    continue;
                }
                if (indexList.contains(globIndex) || indexList.contains(globIndex + 1)) continue;
                indexList.add(globIndex);
                classes.add(arr[globIndex] + "," + arr[globIndex + 1]);
                indexList.add(++globIndex);
                continue;
            }
            if (DocClassUtil.isClassName(arr[i])) {
                indexList.add(i);
                classes.add(arr[i]);
                continue;
            }
            if (indexList.contains(i) || indexList.contains(i + 1)) continue;
            globIndex = i + 1;
            classes.add(arr[i] + "," + arr[globIndex]);
            indexList.add(i);
            indexList.add(i + 1);
        }
        return classes.toArray(new String[classes.size()]);
    }

    public static String[] getMapKeyValueType(String gName) {
        if (gName.contains("<")) {
            String[] arr = new String[2];
            String key = gName.substring(gName.indexOf("<") + 1, gName.indexOf(","));
            String value = gName.substring(gName.indexOf(",") + 1, gName.lastIndexOf(">"));
            arr[0] = key;
            arr[1] = value;
            return arr;
        }
        return new String[0];
    }

    public static String processTypeNameForParams(String javaTypeName) {
        if (StringUtil.isEmpty((String)javaTypeName)) {
            return "object";
        }
        if (javaTypeName.length() == 1) {
            return "object";
        }
        if (javaTypeName.contains("[]")) {
            return "array";
        }
        switch (javaTypeName) {
            case "java.lang.String": 
            case "string": 
            case "char": 
            case "java.util.Byte": 
            case "byte": 
            case "date": 
            case "localdatetime": 
            case "localdate": 
            case "localtime": 
            case "timestamp": {
                return "string";
            }
            case "java.util.List": 
            case "list": 
            case "java.util.Set": 
            case "set": 
            case "java.util.LinkedList": 
            case "linkedlist": 
            case "java.util.ArrayList": 
            case "arraylist": 
            case "java.util.TreeSet": 
            case "treeset": {
                return "array";
            }
            case "java.lang.Integer": 
            case "integer": 
            case "int": {
                return "int32";
            }
            case "short": 
            case "java.lang.Short": {
                return "int16";
            }
            case "double": {
                return "double";
            }
            case "java.lang.Long": 
            case "long": {
                return "int64";
            }
            case "java.lang.Float": 
            case "float": {
                return "float";
            }
            case "bigdecimal": 
            case "biginteger": {
                return "number";
            }
            case "java.lang.Boolean": 
            case "boolean": {
                return "boolean";
            }
            case "map": {
                return "map";
            }
            case "multipartfile": {
                return "file";
            }
        }
        return "object";
    }

    public static ApiReturn processReturnType(String fullyName) {
        ReturnTypeProcessor processor = new ReturnTypeProcessor();
        processor.setTypeName(fullyName);
        return processor.process();
    }

    public static String rewriteRequestParam(String typeName) {
        switch (typeName) {
            case "org.springframework.data.domain.Pageable": {
                return "org.springframework.data.domain.PageRequest";
            }
        }
        return typeName;
    }

    private static boolean isClassName(String className) {
        className = className.replaceAll("[^<>]", "");
        Stack<Character> stack = new Stack<Character>();
        for (char c : className.toCharArray()) {
            if (c == '<') {
                stack.push(Character.valueOf('>'));
                continue;
            }
            if (!stack.isEmpty() && c == ((Character)stack.pop()).charValue()) continue;
            return false;
        }
        return stack.isEmpty();
    }
}

