/*
 * Decompiled with CFR 0.152.
 */
package com.github.springtestdbunit.dataset;

import com.github.springtestdbunit.dataset.DataSetLoader;
import org.dbunit.dataset.IDataSet;
import org.springframework.core.io.ClassRelativeResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataSetLoader
implements DataSetLoader {
    @Override
    public IDataSet loadDataSet(Class<?> testClass, String location) throws Exception {
        String[] resourceLocations;
        ResourceLoader resourceLoader = this.getResourceLoader(testClass);
        for (String resourceLocation : resourceLocations = this.getResourceLocations(testClass, location)) {
            Resource resource = resourceLoader.getResource(resourceLocation);
            if (!resource.exists()) continue;
            return this.createDataSet(resource);
        }
        return null;
    }

    protected ResourceLoader getResourceLoader(Class<?> testClass) {
        return new ClassRelativeResourceLoader(testClass);
    }

    protected String[] getResourceLocations(Class<?> testClass, String location) {
        return new String[]{location};
    }

    protected abstract IDataSet createDataSet(Resource var1) throws Exception;
}

