/*
 * Decompiled with CFR 0.152.
 */
package redis;

import com.google.common.base.Charsets;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import redis.RedisProtocol;
import redis.util.Encoding;

public class Command {
    public static final char ARGS_PREFIX = '*';
    public static final char BYTES_PREFIX = '$';
    public static final byte[] CRLF = "\r\n".getBytes();
    public static final byte[] EMPTY_BYTES = new byte[0];
    private final Object name;
    private final Object[] objects;
    private final Object object1;
    private final Object object2;
    private final Object object3;

    public Command(Object[] objects) {
        this(null, null, null, null, objects);
    }

    public Command(Object name) {
        this(name, null, null, null, null);
    }

    public Command(Object name, Object[] objects) {
        this(name, null, null, null, objects);
    }

    public Command(Object name, Object object1) {
        this(name, object1, null, null, null);
    }

    public Command(Object name, Object object1, Object[] objects) {
        this(name, object1, null, null, objects);
    }

    public Command(Object name, Object object1, Object object2) {
        this(name, object1, object2, null, null);
    }

    public Command(Object name, Object object1, Object object2, Object object3) {
        this(name, object1, object2, object3, null);
    }

    private Command(Object name, Object object1, Object object2, Object object3, Object[] objects) {
        this.name = name;
        this.object1 = object1;
        this.object2 = object2;
        this.object3 = object3;
        this.objects = objects;
    }

    public void write(OutputStream os) throws IOException {
        Command.writeDirect(os, this.name, this.object1, this.object2, this.object3, this.objects);
    }

    public static void writeDirect(OutputStream os, Object name, Object object1, Object object2, Object object3, Object[] objects) throws IOException {
        int others = (object1 == null ? 0 : 1) + (object2 == null ? 0 : 1) + (object3 == null ? 0 : 1) + (name == null ? 0 : 1);
        int length = objects == null ? 0 : objects.length;
        os.write(42);
        os.write(Encoding.numToBytes((long)(length + others), (boolean)true));
        if (name != null) {
            Command.writeObject(os, name);
        }
        if (object1 != null) {
            Command.writeObject(os, object1);
        }
        if (object2 != null) {
            Command.writeObject(os, object2);
        }
        if (object3 != null) {
            Command.writeObject(os, object3);
        }
        if (objects != null) {
            for (Object object : objects) {
                Command.writeObject(os, object);
            }
        }
    }

    private static void writeObject(OutputStream os, Object object) throws IOException {
        byte[] argument = object == null ? EMPTY_BYTES : (object instanceof byte[] ? (byte[])object : object.toString().getBytes(Charsets.UTF_8));
        Command.writeArgument(os, argument);
    }

    private static void writeArgument(OutputStream os, byte[] argument) throws IOException {
        os.write(36);
        os.write(Encoding.numToBytes((long)argument.length, (boolean)true));
        os.write(argument);
        os.write(CRLF);
    }

    public static Command read(InputStream is) throws IOException {
        int read = is.read();
        if (read == 42) {
            long numArgs = RedisProtocol.readLong(is);
            if (numArgs < 0L || numArgs > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Invalid size: " + numArgs);
            }
            byte[][] byteArrays = new byte[(int)numArgs][];
            int i = 0;
            while ((long)i < numArgs) {
                if (is.read() != 36) {
                    throw new IOException("Unexpected character");
                }
                byteArrays[i] = RedisProtocol.readBytes(is);
                ++i;
            }
            return new Command((Object[])byteArrays);
        }
        DataInputStream dis = new DataInputStream(is);
        if (read == 77 || read == 109) {
            String command = ("m" + dis.readLine()).toLowerCase();
            if (command.equals("monitor")) {
                byte[][] byteArrays = new byte[][]{"monitor".getBytes()};
                return new Command((Object[])byteArrays);
            }
        } else if (read == 81 || read == 113) {
            String command = ("q" + dis.readLine()).toLowerCase();
            if (command.equals("quit")) {
                byte[][] byteArrays = new byte[][]{"quit".getBytes()};
                return new Command((Object[])byteArrays);
            }
        } else if (read == 80 || read == 112) {
            String command = ("p" + dis.readLine()).toLowerCase();
            if (command.equals("ping")) {
                byte[][] byteArrays = new byte[][]{"ping".getBytes()};
                return new Command((Object[])byteArrays);
            }
        } else if (read == -1) {
            return null;
        }
        throw new IOException("Unexpected character");
    }
}

