/*
 * Decompiled with CFR 0.152.
 */
package redis.reply;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import redis.reply.Reply;

public class StatusReply
implements Reply<String> {
    public static final char MARKER = '+';
    private final String status;
    private byte[] statusBytes;

    public StatusReply(String status) {
        this.status = status;
        this.statusBytes = status.getBytes();
    }

    public StatusReply(byte[] statusBytes, Charset charset) {
        this.status = new String(statusBytes, charset);
        this.statusBytes = statusBytes;
    }

    @Override
    public String data() {
        return this.status;
    }

    @Override
    public void write(OutputStream os) throws IOException {
        os.write(43);
        os.write(this.statusBytes);
        os.write(CRLF);
    }
}

