/*
 * Decompiled with CFR 0.152.
 */
package com.eaio.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RangeOutputStream
extends FilterOutputStream {
    private long start;
    private long end;

    public RangeOutputStream(OutputStream out, long start) {
        super(out);
        assert (start >= 0L);
        this.start = start;
        this.end = Long.MIN_VALUE;
    }

    public RangeOutputStream(OutputStream out, long start, long end) {
        super(out);
        assert (start >= 0L);
        assert (end >= start);
        this.start = start;
        this.end = end;
    }

    public void write(int b) throws IOException {
        --this.start;
        if (this.end == Long.MIN_VALUE) {
            if (this.start < 0L) {
                this.out.write(b);
            }
        } else {
            --this.end;
            if (this.start < 0L && this.end >= 0L) {
                super.write(b);
            }
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if ((off | len | b.length - (len + off) | off + len) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.end == Long.MIN_VALUE) {
            if (this.start >= (long)len) {
                this.start -= (long)len;
            } else if (this.start < 0L) {
                this.out.write(b, off, len);
                this.start -= (long)len;
            } else {
                super.write(b, off, len);
            }
        } else if (this.start < 0L && this.end >= (long)len) {
            this.out.write(b, off, len);
            this.start -= (long)len;
            this.end -= (long)len;
        } else if (this.start >= (long)len || this.end < 0L) {
            this.start -= (long)len;
            this.end -= (long)len;
        } else {
            super.write(b, off, len);
        }
    }
}

