/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.parser.ast;

import jetbrick.template.parser.ast.AstDirective;
import jetbrick.template.parser.ast.AstExpression;
import jetbrick.template.parser.ast.AstStatementList;
import jetbrick.template.parser.ast.Position;
import jetbrick.template.runtime.InterpretContext;
import jetbrick.template.runtime.InterpretException;
import jetbrick.template.runtime.JetForIterator;
import jetbrick.template.runtime.ValueStack;

public final class AstDirectiveFor
extends AstDirective {
    private final String identifier;
    private final AstExpression expression;
    private final AstStatementList statements;
    private final AstStatementList elseStatements;

    public AstDirectiveFor(String identifier, AstExpression expression, AstStatementList statements, AstStatementList elseStatements, Position position) {
        super(position);
        this.identifier = identifier;
        this.expression = expression;
        this.statements = statements;
        this.elseStatements = elseStatements;
    }

    @Override
    public void execute(InterpretContext ctx) throws InterpretException {
        Object result = this.expression.execute(ctx);
        JetForIterator it = new JetForIterator(result);
        if (it.getSize() > 0) {
            ValueStack valueStack = ctx.getValueStack();
            it.setOuter((JetForIterator)valueStack.getValue("for"));
            Object outsideIdentifier = valueStack.getValue(this.identifier);
            valueStack.setLocal("for", it);
            while (it.hasNext()) {
                Object item = it.next();
                try {
                    valueStack.setLocal(this.identifier, item);
                }
                catch (IllegalStateException e) {
                    throw new InterpretException("iterate error when index = %s", it.getIndex()).cause(e).set(this.expression.getPosition());
                }
                this.statements.execute(ctx);
                int signal = ctx.getSignal();
                if (signal == 0) continue;
                if (signal == 1) {
                    ctx.setSignal(0);
                    break;
                }
                if (signal == 2) {
                    ctx.setSignal(0);
                    continue;
                }
                return;
            }
            valueStack.setLocal(this.identifier, outsideIdentifier);
            valueStack.setLocal("for", it.getOuter());
        } else if (this.elseStatements != null) {
            this.elseStatements.execute(ctx);
        }
    }
}

