/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.parser.ast;

import java.io.IOException;
import jetbrick.template.parser.ast.ALU;
import jetbrick.template.parser.ast.AstExpression;
import jetbrick.template.parser.ast.AstStatement;
import jetbrick.template.runtime.InterpretContext;
import jetbrick.template.runtime.InterpretException;
import jetbrick.util.ExceptionUtils;
import jetbrick.util.StringEscapeUtils;

public final class AstValueEscaped
extends AstStatement {
    private final AstExpression expression;

    public AstValueEscaped(AstExpression expression) {
        this.expression = expression;
    }

    @Override
    public void execute(InterpretContext ctx) throws InterpretException {
        Object value = this.expression.execute(ctx);
        if (value != null && value != ALU.VOID) {
            String xml = StringEscapeUtils.escapeXml((String)value.toString());
            try {
                ctx.getWriter().print(xml);
            }
            catch (IOException e) {
                throw ExceptionUtils.unchecked((Throwable)e);
            }
        }
    }
}

