/*
 * Decompiled with CFR 0.152.
 */
package com.github.taccisum.swagger.autoconfigure;

import com.github.taccisum.swagger.configurer.DescriptionBuilder;
import com.github.taccisum.swagger.configurer.DocketBuilder;
import com.github.taccisum.swagger.configurer.DocketBuilderInterceptor;
import com.github.taccisum.swagger.configurer.UIConfigurationBuilderAdapter;
import com.github.taccisum.swagger.configurer.concrete.DefaultDescriptionBuilder;
import com.github.taccisum.swagger.configurer.config.SwaggerProperties;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger.web.UiConfiguration;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@EnableSwagger2
public class SwaggerAutoConfiguration {
    @Autowired
    private SwaggerProperties properties;
    @Autowired
    private Environment environment;
    @Autowired(required=false)
    private List<DocketBuilderInterceptor> interceptors;

    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(value="swagger")
    public SwaggerProperties swaggerProperties() {
        return new SwaggerProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    public Docket docket() {
        DocketBuilder builder = new DocketBuilder(this.properties);
        builder.setDescriptionBuilder((DescriptionBuilder)new DefaultDescriptionBuilder(this.environment, this.properties.getInfo().getDescription()));
        if (!CollectionUtils.isEmpty(this.interceptors)) {
            this.interceptors.forEach(arg_0 -> ((DocketBuilder)builder).addInterceptor(arg_0));
        }
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public UiConfiguration uiConfiguration() {
        return new UIConfigurationBuilderAdapter(this.properties).build();
    }
}

