/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptmavenplugin.mojo;

import com.ulisesbocchio.jasyptmavenplugin.mojo.AbstractReencryptMojo;
import com.ulisesbocchio.jasyptspringboot.properties.JasyptEncryptorConfigurationProperties;
import com.ulisesbocchio.jasyptspringboot.util.AsymmetricCryptography;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.springframework.core.env.Environment;

@Mojo(name="upgrade", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class UpgradeMojo
extends AbstractReencryptMojo {
    @Parameter(property="jasypt.plugin.old.major-version", defaultValue="2")
    private int oldMajorVersion = 2;

    @Override
    protected void configure(JasyptEncryptorConfigurationProperties properties) {
        Environment environment = this.getEnvironment();
        this.setIfNotNull(arg_0 -> ((JasyptEncryptorConfigurationProperties)properties).setPassword(arg_0), environment.getProperty("jasypt.encryptor.password"));
        this.setIfNotNull(arg_0 -> ((JasyptEncryptorConfigurationProperties)properties).setPrivateKeyFormat(arg_0), environment.getProperty("jasypt.encryptor.private-key-format", AsymmetricCryptography.KeyFormat.class));
        this.setIfNotNull(arg_0 -> ((JasyptEncryptorConfigurationProperties)properties).setPrivateKeyString(arg_0), environment.getProperty("jasypt.encryptor.private-key-string"));
        this.setIfNotNull(arg_0 -> ((JasyptEncryptorConfigurationProperties)properties).setPrivateKeyLocation(arg_0), environment.getProperty("jasypt.encryptor.private-key-location"));
        if (this.oldMajorVersion >= 2) {
            throw new RuntimeException("Unrecognised major version " + this.oldMajorVersion);
        }
        this.upgradeFrom2(properties);
    }

    private void upgradeFrom2(JasyptEncryptorConfigurationProperties properties) {
        properties.setAlgorithm("PBEWithMD5AndDES");
        properties.setKeyObtentionIterations("1000");
        properties.setPoolSize("1");
        properties.setProviderName(null);
        properties.setProviderClassName(null);
        properties.setSaltGeneratorClassname("org.jasypt.salt.RandomSaltGenerator");
        properties.setIvGeneratorClassname("org.jasypt.iv.NoIvGenerator");
        properties.setStringOutputType("base64");
    }
}

