/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.service.cashcoupons;

import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.http.DefaultHttpClientBuilder;
import com.wechat.pay.java.core.http.HostName;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.http.HttpHeaders;
import com.wechat.pay.java.core.http.HttpMethod;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.HttpResponse;
import com.wechat.pay.java.core.http.JsonRequestBody;
import com.wechat.pay.java.core.http.MediaType;
import com.wechat.pay.java.core.http.QueryParameter;
import com.wechat.pay.java.core.http.RequestBody;
import com.wechat.pay.java.core.http.UrlEncoder;
import com.wechat.pay.java.core.util.GsonUtil;
import com.wechat.pay.java.service.cashcoupons.model.AvailableMerchantCollection;
import com.wechat.pay.java.service.cashcoupons.model.AvailableSingleitemCollection;
import com.wechat.pay.java.service.cashcoupons.model.Callback;
import com.wechat.pay.java.service.cashcoupons.model.Coupon;
import com.wechat.pay.java.service.cashcoupons.model.CouponCollection;
import com.wechat.pay.java.service.cashcoupons.model.CreateCouponStockRequest;
import com.wechat.pay.java.service.cashcoupons.model.CreateCouponStockResponse;
import com.wechat.pay.java.service.cashcoupons.model.ListAvailableMerchantsRequest;
import com.wechat.pay.java.service.cashcoupons.model.ListAvailableSingleitemsRequest;
import com.wechat.pay.java.service.cashcoupons.model.ListCouponsByFilterRequest;
import com.wechat.pay.java.service.cashcoupons.model.ListStocksRequest;
import com.wechat.pay.java.service.cashcoupons.model.PauseStockRequest;
import com.wechat.pay.java.service.cashcoupons.model.PauseStockResponse;
import com.wechat.pay.java.service.cashcoupons.model.QueryCallbackRequest;
import com.wechat.pay.java.service.cashcoupons.model.QueryCouponRequest;
import com.wechat.pay.java.service.cashcoupons.model.QueryStockRequest;
import com.wechat.pay.java.service.cashcoupons.model.RefundFlowRequest;
import com.wechat.pay.java.service.cashcoupons.model.RefundFlowResponse;
import com.wechat.pay.java.service.cashcoupons.model.RestartStockRequest;
import com.wechat.pay.java.service.cashcoupons.model.RestartStockResponse;
import com.wechat.pay.java.service.cashcoupons.model.SendCouponRequest;
import com.wechat.pay.java.service.cashcoupons.model.SendCouponResponse;
import com.wechat.pay.java.service.cashcoupons.model.SetCallbackRequest;
import com.wechat.pay.java.service.cashcoupons.model.SetCallbackResponse;
import com.wechat.pay.java.service.cashcoupons.model.StartStockRequest;
import com.wechat.pay.java.service.cashcoupons.model.StartStockResponse;
import com.wechat.pay.java.service.cashcoupons.model.Stock;
import com.wechat.pay.java.service.cashcoupons.model.StockCollection;
import com.wechat.pay.java.service.cashcoupons.model.StopStockRequest;
import com.wechat.pay.java.service.cashcoupons.model.StopStockResponse;
import com.wechat.pay.java.service.cashcoupons.model.UseFlowRequest;
import com.wechat.pay.java.service.cashcoupons.model.UseFlowResponse;
import java.util.Objects;

public class CashCouponsService {
    private final HttpClient httpClient;
    private final HostName hostName;

    private CashCouponsService(HttpClient httpClient, HostName hostName) {
        this.httpClient = Objects.requireNonNull(httpClient);
        this.hostName = hostName;
    }

    public Callback queryCallback(QueryCallbackRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/favor/callbacks";
        QueryCallbackRequest realRequest = request;
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getMchid() != null) {
            queryParameter.add("mchid", (Object)UrlEncoder.urlEncode((String)realRequest.getMchid()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, Callback.class);
        return (Callback)httpResponse.getServiceResponse();
    }

    public SetCallbackResponse setCallback(SetCallbackRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/favor/callbacks";
        SetCallbackRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, SetCallbackResponse.class);
        return (SetCallbackResponse)httpResponse.getServiceResponse();
    }

    public CouponCollection listCouponsByFilter(ListCouponsByFilterRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/favor/users/{openid}/coupons";
        ListCouponsByFilterRequest realRequest = request;
        requestPath = requestPath.replace("{openid}", UrlEncoder.urlEncode((String)realRequest.getOpenid()));
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getAppid() != null) {
            queryParameter.add("appid", (Object)UrlEncoder.urlEncode((String)realRequest.getAppid()));
        }
        if (realRequest.getStockId() != null) {
            queryParameter.add("stock_id", (Object)UrlEncoder.urlEncode((String)realRequest.getStockId()));
        }
        if (realRequest.getStatus() != null) {
            queryParameter.add("status", (Object)UrlEncoder.urlEncode((String)realRequest.getStatus()));
        }
        if (realRequest.getCreatorMchid() != null) {
            queryParameter.add("creator_mchid", (Object)UrlEncoder.urlEncode((String)realRequest.getCreatorMchid()));
        }
        if (realRequest.getSenderMchid() != null) {
            queryParameter.add("sender_mchid", (Object)UrlEncoder.urlEncode((String)realRequest.getSenderMchid()));
        }
        if (realRequest.getAvailableMchid() != null) {
            queryParameter.add("available_mchid", (Object)UrlEncoder.urlEncode((String)realRequest.getAvailableMchid()));
        }
        if (realRequest.getOffset() != null) {
            queryParameter.add("offset", (Object)UrlEncoder.urlEncode((String)realRequest.getOffset().toString()));
        }
        if (realRequest.getLimit() != null) {
            queryParameter.add("limit", (Object)UrlEncoder.urlEncode((String)realRequest.getLimit().toString()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, CouponCollection.class);
        return (CouponCollection)httpResponse.getServiceResponse();
    }

    public Coupon queryCoupon(QueryCouponRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/favor/users/{openid}/coupons/{coupon_id}";
        QueryCouponRequest realRequest = request;
        requestPath = requestPath.replace("{coupon_id}", UrlEncoder.urlEncode((String)realRequest.getCouponId()));
        requestPath = requestPath.replace("{openid}", UrlEncoder.urlEncode((String)realRequest.getOpenid()));
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getAppid() != null) {
            queryParameter.add("appid", (Object)UrlEncoder.urlEncode((String)realRequest.getAppid()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, Coupon.class);
        return (Coupon)httpResponse.getServiceResponse();
    }

    public SendCouponResponse sendCoupon(SendCouponRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/favor/users/{openid}/coupons";
        SendCouponRequest realRequest = request;
        requestPath = requestPath.replace("{openid}", UrlEncoder.urlEncode((String)realRequest.getOpenid()));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, SendCouponResponse.class);
        return (SendCouponResponse)httpResponse.getServiceResponse();
    }

    public CreateCouponStockResponse createCouponStock(CreateCouponStockRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/favor/coupon-stocks";
        CreateCouponStockRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, CreateCouponStockResponse.class);
        return (CreateCouponStockResponse)httpResponse.getServiceResponse();
    }

    public AvailableMerchantCollection listAvailableMerchants(ListAvailableMerchantsRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/favor/stocks/{stock_id}/merchants";
        ListAvailableMerchantsRequest realRequest = request;
        requestPath = requestPath.replace("{stock_id}", UrlEncoder.urlEncode((String)realRequest.getStockId()));
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getOffset() != null) {
            queryParameter.add("offset", (Object)UrlEncoder.urlEncode((String)realRequest.getOffset().toString()));
        }
        if (realRequest.getLimit() != null) {
            queryParameter.add("limit", (Object)UrlEncoder.urlEncode((String)realRequest.getLimit().toString()));
        }
        if (realRequest.getStockCreatorMchid() != null) {
            queryParameter.add("stock_creator_mchid", (Object)UrlEncoder.urlEncode((String)realRequest.getStockCreatorMchid()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, AvailableMerchantCollection.class);
        return (AvailableMerchantCollection)httpResponse.getServiceResponse();
    }

    public AvailableSingleitemCollection listAvailableSingleitems(ListAvailableSingleitemsRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/favor/stocks/{stock_id}/items";
        ListAvailableSingleitemsRequest realRequest = request;
        requestPath = requestPath.replace("{stock_id}", UrlEncoder.urlEncode((String)realRequest.getStockId()));
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getOffset() != null) {
            queryParameter.add("offset", (Object)UrlEncoder.urlEncode((String)realRequest.getOffset().toString()));
        }
        if (realRequest.getLimit() != null) {
            queryParameter.add("limit", (Object)UrlEncoder.urlEncode((String)realRequest.getLimit().toString()));
        }
        if (realRequest.getStockCreatorMchid() != null) {
            queryParameter.add("stock_creator_mchid", (Object)UrlEncoder.urlEncode((String)realRequest.getStockCreatorMchid()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, AvailableSingleitemCollection.class);
        return (AvailableSingleitemCollection)httpResponse.getServiceResponse();
    }

    public StockCollection listStocks(ListStocksRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/favor/stocks";
        ListStocksRequest realRequest = request;
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getOffset() != null) {
            queryParameter.add("offset", (Object)UrlEncoder.urlEncode((String)realRequest.getOffset().toString()));
        }
        if (realRequest.getLimit() != null) {
            queryParameter.add("limit", (Object)UrlEncoder.urlEncode((String)realRequest.getLimit().toString()));
        }
        if (realRequest.getStockCreatorMchid() != null) {
            queryParameter.add("stock_creator_mchid", (Object)UrlEncoder.urlEncode((String)realRequest.getStockCreatorMchid()));
        }
        if (realRequest.getCreateStartTime() != null) {
            queryParameter.add("create_start_time", (Object)UrlEncoder.urlEncode((String)realRequest.getCreateStartTime()));
        }
        if (realRequest.getCreateEndTime() != null) {
            queryParameter.add("create_end_time", (Object)UrlEncoder.urlEncode((String)realRequest.getCreateEndTime()));
        }
        if (realRequest.getStatus() != null) {
            queryParameter.add("status", (Object)UrlEncoder.urlEncode((String)realRequest.getStatus()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, StockCollection.class);
        return (StockCollection)httpResponse.getServiceResponse();
    }

    public PauseStockResponse pauseStock(PauseStockRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/favor/stocks/{stock_id}/pause";
        PauseStockRequest realRequest = request;
        requestPath = requestPath.replace("{stock_id}", UrlEncoder.urlEncode((String)realRequest.getStockId()));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, PauseStockResponse.class);
        return (PauseStockResponse)httpResponse.getServiceResponse();
    }

    public Stock queryStock(QueryStockRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/favor/stocks/{stock_id}";
        QueryStockRequest realRequest = request;
        requestPath = requestPath.replace("{stock_id}", UrlEncoder.urlEncode((String)realRequest.getStockId()));
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getStockCreatorMchid() != null) {
            queryParameter.add("stock_creator_mchid", (Object)UrlEncoder.urlEncode((String)realRequest.getStockCreatorMchid()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, Stock.class);
        return (Stock)httpResponse.getServiceResponse();
    }

    public RefundFlowResponse refundFlow(RefundFlowRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/favor/stocks/{stock_id}/refund-flow";
        RefundFlowRequest realRequest = request;
        requestPath = requestPath.replace("{stock_id}", UrlEncoder.urlEncode((String)realRequest.getStockId()));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, RefundFlowResponse.class);
        return (RefundFlowResponse)httpResponse.getServiceResponse();
    }

    public RestartStockResponse restartStock(RestartStockRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/favor/stocks/{stock_id}/restart";
        RestartStockRequest realRequest = request;
        requestPath = requestPath.replace("{stock_id}", UrlEncoder.urlEncode((String)realRequest.getStockId()));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, RestartStockResponse.class);
        return (RestartStockResponse)httpResponse.getServiceResponse();
    }

    public StartStockResponse startStock(StartStockRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/favor/stocks/{stock_id}/start";
        StartStockRequest realRequest = request;
        requestPath = requestPath.replace("{stock_id}", UrlEncoder.urlEncode((String)realRequest.getStockId()));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, StartStockResponse.class);
        return (StartStockResponse)httpResponse.getServiceResponse();
    }

    public StopStockResponse stopStock(StopStockRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/favor/stocks/{stock_id}/stop";
        StopStockRequest realRequest = request;
        requestPath = requestPath.replace("{stock_id}", UrlEncoder.urlEncode((String)realRequest.getStockId()));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, StopStockResponse.class);
        return (StopStockResponse)httpResponse.getServiceResponse();
    }

    public UseFlowResponse useFlow(UseFlowRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/favor/stocks/{stock_id}/use-flow";
        UseFlowRequest realRequest = request;
        requestPath = requestPath.replace("{stock_id}", UrlEncoder.urlEncode((String)realRequest.getStockId()));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, UseFlowResponse.class);
        return (UseFlowResponse)httpResponse.getServiceResponse();
    }

    private RequestBody createRequestBody(Object request) {
        return new JsonRequestBody.Builder().body(GsonUtil.toJson((Object)request)).build();
    }

    public static class Builder {
        private HttpClient httpClient;
        private HostName hostName;

        public Builder config(Config config) {
            this.httpClient = new DefaultHttpClientBuilder().config(config).build();
            return this;
        }

        public Builder hostName(HostName hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public CashCouponsService build() {
            return new CashCouponsService(this.httpClient, this.hostName);
        }
    }
}

