/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class NativeUtil {
    public static final String NATIVE_FOLDER_PATH_PREFIX = "nativeutils";
    private static final int MIN_PREFIX_LENGTH = 3;
    private static Path temporaryDir;

    private NativeUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLibraryFromJar(String path) throws IOException {
        String filename;
        if (null == path || !path.startsWith("/")) {
            throw new IllegalArgumentException("The path has to be absolute (start with '/').");
        }
        String[] parts = path.split("/");
        String string = filename = parts.length > 1 ? parts[parts.length - 1] : null;
        if (filename == null || filename.length() < 3) {
            throw new IllegalArgumentException("The filename has to be at least 3 characters long.");
        }
        if (temporaryDir == null) {
            temporaryDir = NativeUtil.createTempDirectory(NATIVE_FOLDER_PATH_PREFIX);
            temporaryDir.toFile().deleteOnExit();
        }
        Path temp = temporaryDir.resolve(filename);
        try (InputStream is = NativeUtil.class.getResourceAsStream(path);){
            if (!temporaryDir.toFile().canWrite()) {
                throw new IOException("Can't write to temporary directory.");
            }
            Files.copy(is, temp.toAbsolutePath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            NativeUtil.delete(temp);
            throw e;
        }
        catch (NullPointerException e) {
            NativeUtil.delete(temp);
            throw new FileNotFoundException("File " + path + " was not found inside JAR.");
        }
        try {
            System.load(temp.toAbsolutePath().toString());
        }
        finally {
            if (NativeUtil.isPosixCompliant()) {
                NativeUtil.delete(temp);
            } else {
                temp.toFile().deleteOnExit();
            }
        }
    }

    private static void delete(Path path) {
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Path createTempDirectory(String prefix) throws IOException {
        return Files.createTempDirectory(prefix + System.nanoTime(), new FileAttribute[0]);
    }

    private static boolean isPosixCompliant() {
        try {
            return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
        }
        catch (SecurityException | FileSystemNotFoundException | ProviderNotFoundException e) {
            return false;
        }
    }
}

