/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.plugin;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.spring.plugin.AbstractOperationBuilderPlugin;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.service.ListVendorExtension;
import springfox.documentation.service.VendorExtension;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.OperationContext;

@Component
@Order(value=-2147483546)
public class OperationIgnoreParameterPlugin
extends AbstractOperationBuilderPlugin {
    public static final String IGNORE_PARAMETER_EXTENSION_NAME = "x-ignoreParameters";

    public void apply(OperationContext context) {
        ApiOperationSupport apiOperationSupport;
        String[] ignoreParameters;
        Optional apiOperationSupportOptional = context.findAnnotation(ApiOperationSupport.class);
        if (apiOperationSupportOptional.isPresent() && (ignoreParameters = (apiOperationSupport = (ApiOperationSupport)apiOperationSupportOptional.get()).ignoreParameters()) != null && ignoreParameters.length > 0) {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            for (String ignore : ignoreParameters) {
                if (ignore == null || "".equals(ignore) || "null".equals(ignore)) continue;
                map.put(ignore, true);
            }
            if (map.size() > 0) {
                ArrayList<HashMap<String, Boolean>> maps = new ArrayList<HashMap<String, Boolean>>();
                maps.add(map);
                ListVendorExtension listVendorExtension = new ListVendorExtension(IGNORE_PARAMETER_EXTENSION_NAME, maps);
                context.operationBuilder().extensions((List)Lists.newArrayList((Object[])new VendorExtension[]{listVendorExtension}));
            }
        }
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

