/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.net.client;

import com.github.xingshuangs.iot.exceptions.SocketRuntimeException;
import com.github.xingshuangs.iot.net.ICommunicable;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class UdpClientBasic
implements ICommunicable {
    protected InetSocketAddress serverAddress;
    protected DatagramSocket socket;

    public int getLocalPort() {
        DatagramSocket availableSocket = this.getAvailableSocket();
        return availableSocket.getLocalPort();
    }

    public UdpClientBasic() {
        this("127.0.0.1", 8088);
    }

    public UdpClientBasic(String ip, int port) {
        this.serverAddress = new InetSocketAddress(ip, port);
    }

    @Override
    public void close() {
        if (this.socket != null && !this.socket.isClosed()) {
            this.socket.close();
        }
    }

    public void bindServer(String ip, int port) {
        this.serverAddress = new InetSocketAddress(ip, port);
    }

    public DatagramSocket getAvailableSocket() {
        if (this.socket != null) {
            return this.socket;
        }
        try {
            this.socket = new DatagramSocket();
            return this.socket;
        }
        catch (IOException e) {
            throw new SocketRuntimeException(e);
        }
    }

    @Override
    public void write(byte[] data) {
        this.write(data, 0, data.length, this.serverAddress);
    }

    @Override
    public void write(byte[] data, int offset, int length) {
        this.write(data, offset, length, this.serverAddress);
    }

    public void write(byte[] data, int offset, int length, SocketAddress address) {
        DatagramPacket packet = new DatagramPacket(data, offset, length, address);
        this.write(packet);
    }

    public void write(DatagramPacket packet) {
        try {
            DatagramSocket availableSocket = this.getAvailableSocket();
            availableSocket.send(packet);
        }
        catch (IOException e) {
            throw new SocketRuntimeException(e);
        }
    }

    public byte[] read() {
        byte[] buffer = new byte[4096];
        int length = this.read(buffer);
        if (length < 4096) {
            byte[] data = new byte[length];
            System.arraycopy(buffer, 0, data, 0, length);
            return data;
        }
        return buffer;
    }

    @Override
    public int read(byte[] data) {
        return this.read(data, 0, data.length);
    }

    public int read(byte[] data, int timeout) {
        return this.read(data, 0, data.length, timeout);
    }

    @Override
    public int read(byte[] data, int offset, int length) {
        return this.read(data, offset, length, this.serverAddress, 0);
    }

    public int read(byte[] data, int offset, int length, int timeout) {
        return this.read(data, offset, length, this.serverAddress, timeout);
    }

    public int read(byte[] data, SocketAddress address) {
        return this.read(data, 0, data.length, address, 0);
    }

    public int read(byte[] data, SocketAddress address, int timeout) {
        return this.read(data, 0, data.length, address, timeout);
    }

    public int read(byte[] data, int offset, int length, SocketAddress address, int timeout) {
        DatagramPacket packet = new DatagramPacket(data, offset, length, address);
        DatagramPacket res = this.read(packet, timeout);
        return res.getLength();
    }

    public DatagramPacket read(DatagramPacket packet) {
        return this.read(packet, 0);
    }

    public DatagramPacket read(DatagramPacket packet, int timeout) {
        try {
            DatagramSocket availableSocket = this.getAvailableSocket();
            availableSocket.setSoTimeout(timeout);
            availableSocket.receive(packet);
            return packet;
        }
        catch (IOException e) {
            throw new SocketRuntimeException(e);
        }
    }
}

