/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.net.client;

import com.github.xingshuangs.iot.net.client.UdpClientBasic;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpClientSample
extends UdpClientBasic {
    private static final Logger log = LoggerFactory.getLogger(UdpClientSample.class);
    private boolean terminal = false;
    private Consumer<byte[]> commCallback;

    public void setCommCallback(Consumer<byte[]> commCallback) {
        this.commCallback = commCallback;
    }

    public UdpClientSample() {
    }

    public UdpClientSample(String ip, int port) {
        super(ip, port);
    }

    @Override
    public void close() {
        this.terminal = true;
        super.close();
    }

    private void waitForReceiveData() {
        log.debug("\u5f00\u542f\u63a5\u6536\u6570\u636e\u7ebf\u7a0b\uff0c\u8fdc\u7a0b\u7684IP:{}\uff0c\u7aef\u53e3\u53f7\uff1a{}", (Object)this.serverAddress.getAddress().getHostAddress(), (Object)this.serverAddress.getPort());
        while (!this.terminal) {
            try {
                byte[] data = this.read();
                log.debug("\u6570\u636e\u957f\u5ea6\uff1a{}", (Object)data.length);
                if (this.commCallback == null) continue;
                this.commCallback.accept(data);
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
    }

    public void triggerReceive() {
        CompletableFuture.runAsync(this::waitForReceiveData);
    }
}

