/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.net.server;

import com.github.xingshuangs.iot.exceptions.SocketRuntimeException;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketAddress;

public class UdpServerBasic {
    private final int port;
    private DatagramSocket socket;

    public int getPort() {
        return this.port;
    }

    public UdpServerBasic() {
        this(8088);
    }

    public UdpServerBasic(int port) {
        this.port = port;
    }

    public void close() {
        if (this.socket != null && !this.socket.isClosed()) {
            this.socket.close();
        }
    }

    public DatagramSocket getAvailableSocket() {
        if (this.socket != null) {
            return this.socket;
        }
        try {
            this.socket = new DatagramSocket(this.port);
            return this.socket;
        }
        catch (IOException e) {
            throw new SocketRuntimeException(e);
        }
    }

    public void write(byte[] data, SocketAddress address) {
        this.write(data, 0, data.length, address);
    }

    public void write(byte[] data, int offset, int length, SocketAddress address) {
        DatagramPacket packet = new DatagramPacket(data, offset, length, address);
        this.write(packet);
    }

    public void write(DatagramPacket packet) {
        try {
            DatagramSocket availableSocket = this.getAvailableSocket();
            availableSocket.send(packet);
        }
        catch (IOException e) {
            throw new SocketRuntimeException(e);
        }
    }

    public DatagramPacket read(byte[] data) {
        return this.read(data, 0, data.length);
    }

    public DatagramPacket read(byte[] data, int offset, int length) {
        DatagramPacket packet = new DatagramPacket(data, offset, length);
        return this.read(packet);
    }

    public DatagramPacket read(DatagramPacket packet) {
        try {
            DatagramSocket availableSocket = this.getAvailableSocket();
            availableSocket.receive(packet);
            return packet;
        }
        catch (IOException e) {
            throw new SocketRuntimeException(e);
        }
    }
}

