/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.modbus.model;

import com.github.xingshuangs.iot.exceptions.ModbusCommException;
import com.github.xingshuangs.iot.protocol.common.IObjectByteArray;
import com.github.xingshuangs.iot.protocol.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.protocol.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.modbus.enums.EMbFunctionCode;
import com.github.xingshuangs.iot.protocol.modbus.model.MbErrorResponse;
import com.github.xingshuangs.iot.protocol.modbus.model.MbReadCoilResponse;
import com.github.xingshuangs.iot.protocol.modbus.model.MbReadDiscreteInputResponse;
import com.github.xingshuangs.iot.protocol.modbus.model.MbReadHoldRegisterResponse;
import com.github.xingshuangs.iot.protocol.modbus.model.MbReadInputRegisterResponse;
import com.github.xingshuangs.iot.protocol.modbus.model.MbWriteMultipleCoilResponse;
import com.github.xingshuangs.iot.protocol.modbus.model.MbWriteMultipleRegisterResponse;
import com.github.xingshuangs.iot.protocol.modbus.model.MbWriteSingleCoilResponse;
import com.github.xingshuangs.iot.protocol.modbus.model.MbWriteSingleRegisterResponse;

public class MbPdu
implements IObjectByteArray {
    protected EMbFunctionCode functionCode;

    @Override
    public int byteArrayLength() {
        return 1;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(1).putByte(this.functionCode.getCode()).getData();
    }

    public static MbPdu fromBytes(byte[] data) {
        return MbPdu.fromBytes(data, 0);
    }

    public static MbPdu fromBytes(byte[] data, int offset) {
        ByteReadBuff buff = new ByteReadBuff(data, offset);
        EMbFunctionCode functionCode = EMbFunctionCode.from(buff.getByte());
        switch (functionCode) {
            case READ_COIL: {
                return MbReadCoilResponse.fromBytes(data, offset);
            }
            case READ_DISCRETE_INPUT: {
                return MbReadDiscreteInputResponse.fromBytes(data, offset);
            }
            case READ_HOLD_REGISTER: {
                return MbReadHoldRegisterResponse.fromBytes(data, offset);
            }
            case READ_INPUT_REGISTER: {
                return MbReadInputRegisterResponse.fromBytes(data, offset);
            }
            case WRITE_SINGLE_COIL: {
                return MbWriteSingleCoilResponse.fromBytes(data, offset);
            }
            case WRITE_SINGLE_REGISTER: {
                return MbWriteSingleRegisterResponse.fromBytes(data, offset);
            }
            case WRITE_MULTIPLE_COIL: {
                return MbWriteMultipleCoilResponse.fromBytes(data, offset);
            }
            case WRITE_MULTIPLE_REGISTER: {
                return MbWriteMultipleRegisterResponse.fromBytes(data, offset);
            }
            case ERROR_READ_COIL: 
            case ERROR_READ_DISCRETE_INPUT: 
            case ERROR_READ_HOLD_REGISTER: 
            case ERROR_READ_INPUT_REGISTER: 
            case ERROR_WRITE_SINGLE_COIL: 
            case ERROR_WRITE_SINGLE_REGISTER: 
            case ERROR_WRITE_MULTIPLE_COIL: 
            case ERROR_WRITE_MULTIPLE_REGISTER: {
                return MbErrorResponse.fromBytes(data, offset);
            }
        }
        throw new ModbusCommException("\u65e0\u6cd5\u8bc6\u522b\u529f\u80fd\u7801\uff1a" + functionCode.getDescription());
    }

    public EMbFunctionCode getFunctionCode() {
        return this.functionCode;
    }

    public void setFunctionCode(EMbFunctionCode functionCode) {
        this.functionCode = functionCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MbPdu)) {
            return false;
        }
        MbPdu other = (MbPdu)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EMbFunctionCode this$functionCode = this.getFunctionCode();
        EMbFunctionCode other$functionCode = other.getFunctionCode();
        return !(this$functionCode == null ? other$functionCode != null : !((Object)((Object)this$functionCode)).equals((Object)other$functionCode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MbPdu;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EMbFunctionCode $functionCode = this.getFunctionCode();
        result = result * 59 + ($functionCode == null ? 43 : ((Object)((Object)$functionCode)).hashCode());
        return result;
    }

    public String toString() {
        return "MbPdu(functionCode=" + (Object)((Object)this.getFunctionCode()) + ")";
    }
}

