/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.modbus.model;

import com.github.xingshuangs.iot.protocol.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.protocol.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.modbus.enums.EMbFunctionCode;
import com.github.xingshuangs.iot.protocol.modbus.model.MbPdu;
import java.util.Arrays;

public final class MbWriteMultipleRegisterRequest
extends MbPdu {
    private int address;
    private int quantity;
    private int count;
    private byte[] value;

    public MbWriteMultipleRegisterRequest() {
        this.functionCode = EMbFunctionCode.WRITE_MULTIPLE_REGISTER;
    }

    public MbWriteMultipleRegisterRequest(int address, int quantity, byte[] value) {
        this.functionCode = EMbFunctionCode.WRITE_MULTIPLE_REGISTER;
        this.address = address;
        this.quantity = quantity;
        this.count = value.length;
        this.value = value;
    }

    @Override
    public int byteArrayLength() {
        return super.byteArrayLength() + 5 + this.value.length;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(this.byteArrayLength()).putByte(this.functionCode.getCode()).putShort(this.address).putShort(this.quantity).putByte(this.count).putBytes(this.value).getData();
    }

    public static MbWriteMultipleRegisterRequest fromBytes(byte[] data) {
        return MbWriteMultipleRegisterRequest.fromBytes(data, 0);
    }

    public static MbWriteMultipleRegisterRequest fromBytes(byte[] data, int offset) {
        ByteReadBuff buff = new ByteReadBuff(data, offset);
        MbWriteMultipleRegisterRequest res = new MbWriteMultipleRegisterRequest();
        res.functionCode = EMbFunctionCode.from(buff.getByte());
        res.address = buff.getUInt16();
        res.quantity = buff.getUInt16();
        res.count = buff.getByteToInt();
        res.value = buff.getBytes(res.count);
        return res;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MbWriteMultipleRegisterRequest)) {
            return false;
        }
        MbWriteMultipleRegisterRequest other = (MbWriteMultipleRegisterRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getAddress() != other.getAddress()) {
            return false;
        }
        if (this.getQuantity() != other.getQuantity()) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        return Arrays.equals(this.getValue(), other.getValue());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MbWriteMultipleRegisterRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getAddress();
        result = result * 59 + this.getQuantity();
        result = result * 59 + this.getCount();
        result = result * 59 + Arrays.hashCode(this.getValue());
        return result;
    }

    public int getAddress() {
        return this.address;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public int getCount() {
        return this.count;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setAddress(int address) {
        this.address = address;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return "MbWriteMultipleRegisterRequest(address=" + this.getAddress() + ", quantity=" + this.getQuantity() + ", count=" + this.getCount() + ", value=" + Arrays.toString(this.getValue()) + ")";
    }
}

