/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.modbus.model;

import com.github.xingshuangs.iot.protocol.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.protocol.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.modbus.enums.EMbFunctionCode;
import com.github.xingshuangs.iot.protocol.modbus.model.MbPdu;

public final class MbWriteSingleRegisterRequest
extends MbPdu {
    private int address;
    private int value;

    public MbWriteSingleRegisterRequest() {
        this.functionCode = EMbFunctionCode.WRITE_SINGLE_REGISTER;
    }

    public MbWriteSingleRegisterRequest(int address, int value) {
        this.functionCode = EMbFunctionCode.WRITE_SINGLE_REGISTER;
        this.address = address;
        this.value = value;
    }

    @Override
    public int byteArrayLength() {
        return super.byteArrayLength() + 4;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(this.byteArrayLength()).putByte(this.functionCode.getCode()).putShort(this.address).putShort(this.value).getData();
    }

    public static MbWriteSingleRegisterRequest fromBytes(byte[] data) {
        return MbWriteSingleRegisterRequest.fromBytes(data, 0);
    }

    public static MbWriteSingleRegisterRequest fromBytes(byte[] data, int offset) {
        ByteReadBuff buff = new ByteReadBuff(data, offset);
        MbWriteSingleRegisterRequest res = new MbWriteSingleRegisterRequest();
        res.functionCode = EMbFunctionCode.from(buff.getByte());
        res.address = buff.getUInt16();
        res.value = buff.getUInt16();
        return res;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MbWriteSingleRegisterRequest)) {
            return false;
        }
        MbWriteSingleRegisterRequest other = (MbWriteSingleRegisterRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getAddress() != other.getAddress()) {
            return false;
        }
        return this.getValue() == other.getValue();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MbWriteSingleRegisterRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getAddress();
        result = result * 59 + this.getValue();
        return result;
    }

    public int getAddress() {
        return this.address;
    }

    public int getValue() {
        return this.value;
    }

    public void setAddress(int address) {
        this.address = address;
    }

    public void setValue(int value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return "MbWriteSingleRegisterRequest(address=" + this.getAddress() + ", value=" + this.getValue() + ")";
    }
}

