/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.modbus.service;

import com.github.xingshuangs.iot.exceptions.ModbusCommException;
import com.github.xingshuangs.iot.protocol.modbus.model.MbErrorResponse;
import com.github.xingshuangs.iot.protocol.modbus.model.MbPdu;
import com.github.xingshuangs.iot.protocol.modbus.model.MbTcpRequest;
import com.github.xingshuangs.iot.protocol.modbus.model.MbTcpResponse;
import com.github.xingshuangs.iot.protocol.modbus.model.MbapHeader;
import com.github.xingshuangs.iot.protocol.modbus.service.ModbusNetwork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusTcp
extends ModbusNetwork<MbTcpRequest, MbTcpResponse> {
    private static final Logger log = LoggerFactory.getLogger(ModbusTcp.class);

    public ModbusTcp() {
        this(1, "127.0.0.1", 502);
    }

    public ModbusTcp(String ip) {
        this(1, ip, 502);
    }

    public ModbusTcp(int unitId) {
        this(unitId, "127.0.0.1", 502);
    }

    public ModbusTcp(int unitId, String ip) {
        this(unitId, ip, 502);
    }

    public ModbusTcp(int unitId, String ip, int port) {
        super(unitId, ip, port);
        this.tag = "ModbusTcp";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MbTcpResponse readFromServer(MbTcpRequest req) {
        byte[] total;
        MbapHeader header;
        int len;
        if (this.comCallback != null) {
            this.comCallback.accept(req.toByteArray());
        }
        Object object = this.objLock;
        synchronized (object) {
            this.write(req.toByteArray());
            byte[] data = new byte[7];
            len = this.read(data);
            if (len < 7) {
                throw new ModbusCommException(" MbapHeader \u65e0\u6548\uff0c\u8bfb\u53d6\u957f\u5ea6\u4e0d\u4e00\u81f4");
            }
            header = MbapHeader.fromBytes(data);
            total = new byte[data.length + header.getLength() - 1];
            System.arraycopy(data, 0, total, 0, data.length);
            len = this.read(total, data.length, header.getLength() - 1);
        }
        if (len < header.getLength() - 1) {
            throw new ModbusCommException(" MbapHeader\u540e\u9762\u7684\u6570\u636e\u957f\u5ea6\uff0c\u957f\u5ea6\u4e0d\u4e00\u81f4");
        }
        if (this.comCallback != null) {
            this.comCallback.accept(total);
        }
        MbTcpResponse ack = MbTcpResponse.fromBytes(total);
        this.checkResult(req, ack);
        return ack;
    }

    @Override
    protected void checkResult(MbTcpRequest req, MbTcpResponse ack) {
        if (ack.getPdu() == null) {
            throw new ModbusCommException("PDU\u6570\u636e\u4e3anull");
        }
        if (req.getHeader().getTransactionId() != ack.getHeader().getTransactionId()) {
            throw new ModbusCommException("\u4e8b\u52a1\u5143\u6807\u8bc6\u7b26Id\u4e0d\u4e00\u81f4");
        }
        if (ack.getPdu().getFunctionCode().getCode() == (req.getPdu().getFunctionCode().getCode() | 0xFFFFFF80)) {
            MbErrorResponse response = (MbErrorResponse)ack.getPdu();
            throw new ModbusCommException("\u54cd\u5e94\u8fd4\u56de\u5f02\u5e38\uff0c\u5f02\u5e38\u7801:" + response.getErrorCode().getDescription());
        }
        if (ack.getPdu().getFunctionCode().getCode() != req.getPdu().getFunctionCode().getCode()) {
            MbErrorResponse response = (MbErrorResponse)ack.getPdu();
            throw new ModbusCommException("\u8fd4\u56de\u529f\u80fd\u7801\u548c\u53d1\u9001\u529f\u80fd\u7801\u4e0d\u4e00\u81f4\uff0c\u5f02\u5e38\u7801:" + response.getErrorCode().getDescription());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MbPdu readModbusData(MbPdu reqPdu) {
        MbTcpRequest request = MbTcpRequest.createDefault();
        request.getHeader().setUnitId(this.unitId);
        request.setPdu(reqPdu);
        request.selfCheck();
        try {
            MbTcpResponse response = this.readFromServer(request);
            MbPdu mbPdu = response.getPdu();
            return mbPdu;
        }
        finally {
            if (!this.persistence) {
                log.debug("\u7531\u4e8e\u77ed\u8fde\u63a5\u65b9\u5f0f\uff0c\u901a\u4fe1\u5b8c\u6bd5\u89e6\u53d1\u5173\u95ed\u8fde\u63a5\u901a\u9053\uff0c\u670d\u52a1\u7aefIP[{}]", (Object)this.socketAddress);
                this.close();
            }
        }
    }
}

