/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.mp4.model;

import com.github.xingshuangs.iot.protocol.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.mp4.enums.EMp4Type;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4Box;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4DinfBox;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4SmhdBox;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4StblBox;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4TrackInfo;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4VmhdBox;

public class Mp4MinfBox
extends Mp4Box {
    private final Mp4Box mhdBox;
    private final Mp4DinfBox dinfBox;
    private final Mp4StblBox stblBox;

    public Mp4MinfBox(Mp4TrackInfo trackInfo) {
        this.mp4Type = EMp4Type.MINF;
        this.mhdBox = trackInfo.getType().equals("video") ? new Mp4VmhdBox() : new Mp4SmhdBox();
        this.dinfBox = new Mp4DinfBox();
        this.stblBox = new Mp4StblBox(trackInfo);
    }

    @Override
    public int byteArrayLength() {
        return 8 + this.mhdBox.byteArrayLength() + this.dinfBox.byteArrayLength() + this.stblBox.byteArrayLength();
    }

    @Override
    public byte[] toByteArray() {
        int size = this.byteArrayLength();
        return ByteWriteBuff.newInstance(size).putInteger(size).putBytes(this.mp4Type.getByteArray()).putBytes(this.mhdBox.toByteArray()).putBytes(this.dinfBox.toByteArray()).putBytes(this.stblBox.toByteArray()).getData();
    }
}

