/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.mp4.model;

import com.github.xingshuangs.iot.protocol.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.mp4.enums.EMp4Type;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4Box;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4EsdsBox;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4TrackInfo;

public class Mp4Mp4aBox
extends Mp4Box {
    private final byte[] reserved1;
    private final int dataReferenceIndex;
    private final byte[] reserved2;
    private final int channelCount;
    private final int sampleSize;
    private final byte[] preDefined;
    private final byte[] reserved3;
    private final int audioSampleRate;
    private final byte[] reserved4;
    private final Mp4EsdsBox esdsBox;

    public Mp4Mp4aBox(Mp4TrackInfo trackInfo) {
        this.mp4Type = EMp4Type.MP4A;
        this.reserved1 = new byte[6];
        this.dataReferenceIndex = 1;
        this.reserved2 = new byte[8];
        this.channelCount = trackInfo.getChannelCount();
        this.sampleSize = 16;
        this.preDefined = new byte[2];
        this.reserved3 = new byte[2];
        this.audioSampleRate = trackInfo.getAudioSampleRate();
        this.reserved4 = new byte[2];
        this.esdsBox = new Mp4EsdsBox(trackInfo);
    }

    @Override
    public int byteArrayLength() {
        return 36 + this.esdsBox.byteArrayLength();
    }

    @Override
    public byte[] toByteArray() {
        int size = this.byteArrayLength();
        return ByteWriteBuff.newInstance(size).putInteger(size).putBytes(this.mp4Type.getByteArray()).putBytes(this.reserved1).putShort(this.dataReferenceIndex).putBytes(this.reserved2).putShort(this.channelCount).putShort(this.sampleSize).putBytes(this.preDefined).putBytes(this.reserved3).putShort(this.audioSampleRate).putBytes(this.reserved4).putBytes(this.esdsBox.toByteArray()).getData();
    }
}

