/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.mp4.model;

import com.github.xingshuangs.iot.protocol.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.mp4.enums.EMp4Type;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4Box;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4SdtpBox;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4TfdtBox;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4TfhdBox;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4TrackInfo;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4TrunBox;

public class Mp4TrafBox
extends Mp4Box {
    private final Mp4TfhdBox tfhdBox;
    private final Mp4TfdtBox tfdtBox;
    private final Mp4TrunBox trunBox;
    private final Mp4SdtpBox sdtpBox;

    public Mp4TrafBox(long baseMediaDecodeTime, Mp4TrackInfo trackInfo) {
        this.mp4Type = EMp4Type.TRAF;
        this.tfhdBox = new Mp4TfhdBox(trackInfo.getId());
        this.tfdtBox = new Mp4TfdtBox(baseMediaDecodeTime);
        this.trunBox = new Mp4TrunBox(trackInfo.getSampleData());
        this.sdtpBox = new Mp4SdtpBox(trackInfo.getSampleData());
    }

    @Override
    public int byteArrayLength() {
        return 8 + this.tfhdBox.byteArrayLength() + this.tfdtBox.byteArrayLength() + this.trunBox.byteArrayLength() + this.sdtpBox.byteArrayLength();
    }

    @Override
    public byte[] toByteArray() {
        int size = this.byteArrayLength();
        return ByteWriteBuff.newInstance(size).putInteger(size).putBytes(this.mp4Type.getByteArray()).putBytes(this.tfhdBox.toByteArray()).putBytes(this.tfdtBox.toByteArray()).putBytes(this.trunBox.toByteArray()).putBytes(this.sdtpBox.toByteArray()).getData();
    }
}

