/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.mp4.model;

import com.github.xingshuangs.iot.protocol.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.mp4.enums.EMp4Type;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4Box;

public class Mp4TrexBox
extends Mp4Box {
    private final int version;
    private final byte[] flags;
    private final int trackId;
    private final int defaultSampleDescriptionIndex;
    private final int defaultSampleDuration;
    private final int defaultSampleSize;
    private final int defaultSampleFlags;

    public Mp4TrexBox(int trackId) {
        this.mp4Type = EMp4Type.TREX;
        this.version = 0;
        this.flags = new byte[3];
        this.trackId = trackId;
        this.defaultSampleDescriptionIndex = 1;
        this.defaultSampleDuration = 0;
        this.defaultSampleSize = 0;
        this.defaultSampleFlags = 65537;
    }

    @Override
    public int byteArrayLength() {
        return 32;
    }

    @Override
    public byte[] toByteArray() {
        int size = this.byteArrayLength();
        return ByteWriteBuff.newInstance(size).putInteger(size).putBytes(this.mp4Type.getByteArray()).putByte(this.version).putBytes(this.flags).putInteger(this.trackId).putInteger(this.defaultSampleDescriptionIndex).putInteger(this.defaultSampleDuration).putInteger(this.defaultSampleSize).putInteger(this.defaultSampleFlags).getData();
    }
}

