/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtcp.model;

import com.github.xingshuangs.iot.protocol.common.IObjectByteArray;
import com.github.xingshuangs.iot.protocol.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.protocol.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.rtcp.enums.ERtcpPackageType;
import com.github.xingshuangs.iot.utils.BooleanUtil;

public class RtcpHeader
implements IObjectByteArray {
    protected int version;
    protected boolean padding;
    protected int receptionCount;
    protected ERtcpPackageType packageType;
    protected int length;

    @Override
    public int byteArrayLength() {
        return 4;
    }

    @Override
    public byte[] toByteArray() {
        byte res = (byte)(this.version << 6 & 0xC0 | BooleanUtil.setBit(5, this.padding) | this.receptionCount & 0xF);
        return ByteWriteBuff.newInstance(4).putByte(res).putByte(this.packageType.getCode()).putShort(this.length).getData();
    }

    public static RtcpHeader fromBytes(byte[] data) {
        return RtcpHeader.fromBytes(data, 0);
    }

    public static RtcpHeader fromBytes(byte[] data, int offset) {
        if (data.length < 4) {
            throw new IndexOutOfBoundsException("\u89e3\u6790header\u65f6\uff0c\u5b57\u8282\u6570\u7ec4\u957f\u5ea6\u4e0d\u591f");
        }
        ByteReadBuff buff = new ByteReadBuff(data, offset);
        RtcpHeader res = new RtcpHeader();
        byte aByte = buff.getByte();
        res.version = aByte >> 6 & 3;
        res.padding = BooleanUtil.getValue(aByte, 5);
        res.receptionCount = aByte & 0x1F;
        res.packageType = ERtcpPackageType.from(buff.getByte());
        res.length = buff.getUInt16();
        return res;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isPadding() {
        return this.padding;
    }

    public int getReceptionCount() {
        return this.receptionCount;
    }

    public ERtcpPackageType getPackageType() {
        return this.packageType;
    }

    public int getLength() {
        return this.length;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setPadding(boolean padding) {
        this.padding = padding;
    }

    public void setReceptionCount(int receptionCount) {
        this.receptionCount = receptionCount;
    }

    public void setPackageType(ERtcpPackageType packageType) {
        this.packageType = packageType;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtcpHeader)) {
            return false;
        }
        RtcpHeader other = (RtcpHeader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (this.isPadding() != other.isPadding()) {
            return false;
        }
        if (this.getReceptionCount() != other.getReceptionCount()) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        ERtcpPackageType this$packageType = this.getPackageType();
        ERtcpPackageType other$packageType = other.getPackageType();
        return !(this$packageType == null ? other$packageType != null : !((Object)((Object)this$packageType)).equals((Object)other$packageType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RtcpHeader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getVersion();
        result = result * 59 + (this.isPadding() ? 79 : 97);
        result = result * 59 + this.getReceptionCount();
        result = result * 59 + this.getLength();
        ERtcpPackageType $packageType = this.getPackageType();
        result = result * 59 + ($packageType == null ? 43 : ((Object)((Object)$packageType)).hashCode());
        return result;
    }

    public String toString() {
        return "RtcpHeader(version=" + this.getVersion() + ", padding=" + this.isPadding() + ", receptionCount=" + this.getReceptionCount() + ", packageType=" + (Object)((Object)this.getPackageType()) + ", length=" + this.getLength() + ")";
    }
}

