/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtcp.model;

import com.github.xingshuangs.iot.protocol.common.IObjectByteArray;
import com.github.xingshuangs.iot.protocol.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.protocol.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.rtcp.enums.ERtcpSdesItemType;
import com.github.xingshuangs.iot.protocol.rtcp.model.RtcpSdesItem;
import java.util.ArrayList;
import java.util.List;

public class RtcpSdesChunk
implements IObjectByteArray {
    private long sourceId;
    private List<RtcpSdesItem> sdesItems = new ArrayList<RtcpSdesItem>();

    public void addRtcpSdesItem(RtcpSdesItem item) {
        this.sdesItems.add(item);
    }

    public RtcpSdesChunk() {
    }

    public RtcpSdesChunk(long sourceId) {
        this.sourceId = sourceId;
    }

    @Override
    public int byteArrayLength() {
        int sum = this.sdesItems.stream().mapToInt(RtcpSdesItem::byteArrayLength).sum() + 1;
        sum = sum % 2 == 0 ? sum : sum + 1;
        return 4 + sum;
    }

    @Override
    public byte[] toByteArray() {
        ByteWriteBuff buff = ByteWriteBuff.newInstance(this.byteArrayLength()).putInteger(this.sourceId);
        for (RtcpSdesItem item : this.sdesItems) {
            buff.putBytes(item.toByteArray());
        }
        return buff.getData();
    }

    public static RtcpSdesChunk fromBytes(byte[] data) {
        return RtcpSdesChunk.fromBytes(data, 0);
    }

    public static RtcpSdesChunk fromBytes(byte[] data, int offset) {
        ERtcpSdesItemType type;
        if (data.length < 4) {
            throw new IndexOutOfBoundsException("\u89e3\u6790RtcpSdesChunk\u65f6\uff0c\u5b57\u8282\u6570\u7ec4\u957f\u5ea6\u4e0d\u591f");
        }
        int len = offset;
        ByteReadBuff buff = new ByteReadBuff(data, offset);
        RtcpSdesChunk res = new RtcpSdesChunk();
        res.sourceId = buff.getUInt32();
        len += 4;
        while (data.length > len + 2 && (type = ERtcpSdesItemType.from(buff.getByte(len))) != ERtcpSdesItemType.END) {
            RtcpSdesItem item = RtcpSdesItem.fromBytes(data, len);
            res.sdesItems.add(item);
            len += item.byteArrayLength();
        }
        return res;
    }

    public long getSourceId() {
        return this.sourceId;
    }

    public List<RtcpSdesItem> getSdesItems() {
        return this.sdesItems;
    }

    public void setSourceId(long sourceId) {
        this.sourceId = sourceId;
    }

    public void setSdesItems(List<RtcpSdesItem> sdesItems) {
        this.sdesItems = sdesItems;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtcpSdesChunk)) {
            return false;
        }
        RtcpSdesChunk other = (RtcpSdesChunk)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSourceId() != other.getSourceId()) {
            return false;
        }
        List<RtcpSdesItem> this$sdesItems = this.getSdesItems();
        List<RtcpSdesItem> other$sdesItems = other.getSdesItems();
        return !(this$sdesItems == null ? other$sdesItems != null : !((Object)this$sdesItems).equals(other$sdesItems));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RtcpSdesChunk;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $sourceId = this.getSourceId();
        result = result * 59 + (int)($sourceId >>> 32 ^ $sourceId);
        List<RtcpSdesItem> $sdesItems = this.getSdesItems();
        result = result * 59 + ($sdesItems == null ? 43 : ((Object)$sdesItems).hashCode());
        return result;
    }

    public String toString() {
        return "RtcpSdesChunk(sourceId=" + this.getSourceId() + ", sdesItems=" + this.getSdesItems() + ")";
    }
}

