/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtcp.model;

import com.github.xingshuangs.iot.protocol.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.rtcp.enums.ERtcpPackageType;
import com.github.xingshuangs.iot.protocol.rtcp.model.RtcpBasePackage;
import com.github.xingshuangs.iot.protocol.rtcp.model.RtcpHeader;
import com.github.xingshuangs.iot.protocol.rtcp.model.RtcpSdesChunk;
import java.util.ArrayList;
import java.util.List;

public final class RtcpSdesReport
extends RtcpBasePackage {
    private List<RtcpSdesChunk> sdesChunks = new ArrayList<RtcpSdesChunk>();

    public RtcpSdesReport() {
        this.header = new RtcpHeader();
        this.header.version = 2;
        this.header.padding = false;
        this.header.receptionCount = 0;
        this.header.packageType = ERtcpPackageType.SDES;
        this.header.length = 1;
    }

    public void addRtcpSdesChunk(RtcpSdesChunk chunk) {
        this.sdesChunks.add(chunk);
        this.header.receptionCount = this.sdesChunks.size();
        this.header.length = this.byteArrayLength() / 4 - 1;
    }

    @Override
    public int byteArrayLength() {
        int length = 0;
        length += this.header != null ? this.header.byteArrayLength() : 0;
        for (RtcpSdesChunk chunk : this.sdesChunks) {
            length += chunk.byteArrayLength();
        }
        return length;
    }

    @Override
    public byte[] toByteArray() {
        ByteWriteBuff buff = ByteWriteBuff.newInstance(this.byteArrayLength());
        if (this.header != null) {
            buff.putBytes(this.header.toByteArray());
        }
        for (RtcpSdesChunk chunk : this.sdesChunks) {
            buff.putBytes(chunk.toByteArray());
        }
        return buff.getData();
    }

    public static RtcpSdesReport fromBytes(byte[] data) {
        return RtcpSdesReport.fromBytes(data, 0);
    }

    public static RtcpSdesReport fromBytes(byte[] data, int offset) {
        if (data.length < 4) {
            throw new IndexOutOfBoundsException("\u89e3\u6790RtcpReceiverReport\u65f6\uff0c\u5b57\u8282\u6570\u7ec4\u957f\u5ea6\u4e0d\u591f");
        }
        int off = offset;
        RtcpSdesReport res = new RtcpSdesReport();
        res.header = RtcpHeader.fromBytes(data, off);
        off += res.header.byteArrayLength();
        for (int i = 0; i < res.header.getReceptionCount(); ++i) {
            RtcpSdesChunk chunk = RtcpSdesChunk.fromBytes(data, off);
            res.sdesChunks.add(chunk);
            off += chunk.byteArrayLength();
        }
        return res;
    }

    public List<RtcpSdesChunk> getSdesChunks() {
        return this.sdesChunks;
    }

    public void setSdesChunks(List<RtcpSdesChunk> sdesChunks) {
        this.sdesChunks = sdesChunks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtcpSdesReport)) {
            return false;
        }
        RtcpSdesReport other = (RtcpSdesReport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<RtcpSdesChunk> this$sdesChunks = this.getSdesChunks();
        List<RtcpSdesChunk> other$sdesChunks = other.getSdesChunks();
        return !(this$sdesChunks == null ? other$sdesChunks != null : !((Object)this$sdesChunks).equals(other$sdesChunks));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RtcpSdesReport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<RtcpSdesChunk> $sdesChunks = this.getSdesChunks();
        result = result * 59 + ($sdesChunks == null ? 43 : ((Object)$sdesChunks).hashCode());
        return result;
    }

    public String toString() {
        return "RtcpSdesReport(sdesChunks=" + this.getSdesChunks() + ")";
    }
}

