/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtcp.model;

import com.github.xingshuangs.iot.protocol.common.IObjectByteArray;
import com.github.xingshuangs.iot.protocol.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.protocol.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.utils.TimesUtil;
import java.time.LocalDateTime;

public class RtcpSenderInfo
implements IObjectByteArray {
    private long mswTimestamp;
    private long lswTimestamp;
    private LocalDateTime ntpTimestamp;
    private LocalDateTime rtpTimestamp;
    private long senderPacketCount;
    private long senderOctetCount;

    @Override
    public int byteArrayLength() {
        return 20;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(20).putInteger(this.mswTimestamp).putInteger(this.lswTimestamp).putInteger(TimesUtil.getNTPTotalSecond(this.rtpTimestamp)).putInteger(this.senderPacketCount).putInteger(this.senderOctetCount).getData();
    }

    public static RtcpSenderInfo fromBytes(byte[] data) {
        return RtcpSenderInfo.fromBytes(data, 0);
    }

    public static RtcpSenderInfo fromBytes(byte[] data, int offset) {
        if (data.length < 20) {
            throw new IndexOutOfBoundsException("\u89e3\u6790RtcpSenderInfo\u65f6\uff0c\u5b57\u8282\u6570\u7ec4\u957f\u5ea6\u4e0d\u591f");
        }
        ByteReadBuff buff = new ByteReadBuff(data, offset);
        RtcpSenderInfo res = new RtcpSenderInfo();
        res.mswTimestamp = buff.getUInt32();
        res.lswTimestamp = buff.getUInt32();
        res.ntpTimestamp = TimesUtil.getNTPDateTime(res.mswTimestamp);
        res.ntpTimestamp = res.ntpTimestamp.plusNanos(res.lswTimestamp * 232L / 1000L);
        res.rtpTimestamp = TimesUtil.getNTPDateTime(buff.getUInt32());
        res.senderPacketCount = buff.getUInt32();
        res.senderOctetCount = buff.getUInt32();
        return res;
    }

    public long getMswTimestamp() {
        return this.mswTimestamp;
    }

    public long getLswTimestamp() {
        return this.lswTimestamp;
    }

    public LocalDateTime getNtpTimestamp() {
        return this.ntpTimestamp;
    }

    public LocalDateTime getRtpTimestamp() {
        return this.rtpTimestamp;
    }

    public long getSenderPacketCount() {
        return this.senderPacketCount;
    }

    public long getSenderOctetCount() {
        return this.senderOctetCount;
    }

    public void setMswTimestamp(long mswTimestamp) {
        this.mswTimestamp = mswTimestamp;
    }

    public void setLswTimestamp(long lswTimestamp) {
        this.lswTimestamp = lswTimestamp;
    }

    public void setNtpTimestamp(LocalDateTime ntpTimestamp) {
        this.ntpTimestamp = ntpTimestamp;
    }

    public void setRtpTimestamp(LocalDateTime rtpTimestamp) {
        this.rtpTimestamp = rtpTimestamp;
    }

    public void setSenderPacketCount(long senderPacketCount) {
        this.senderPacketCount = senderPacketCount;
    }

    public void setSenderOctetCount(long senderOctetCount) {
        this.senderOctetCount = senderOctetCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtcpSenderInfo)) {
            return false;
        }
        RtcpSenderInfo other = (RtcpSenderInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMswTimestamp() != other.getMswTimestamp()) {
            return false;
        }
        if (this.getLswTimestamp() != other.getLswTimestamp()) {
            return false;
        }
        if (this.getSenderPacketCount() != other.getSenderPacketCount()) {
            return false;
        }
        if (this.getSenderOctetCount() != other.getSenderOctetCount()) {
            return false;
        }
        LocalDateTime this$ntpTimestamp = this.getNtpTimestamp();
        LocalDateTime other$ntpTimestamp = other.getNtpTimestamp();
        if (this$ntpTimestamp == null ? other$ntpTimestamp != null : !((Object)this$ntpTimestamp).equals(other$ntpTimestamp)) {
            return false;
        }
        LocalDateTime this$rtpTimestamp = this.getRtpTimestamp();
        LocalDateTime other$rtpTimestamp = other.getRtpTimestamp();
        return !(this$rtpTimestamp == null ? other$rtpTimestamp != null : !((Object)this$rtpTimestamp).equals(other$rtpTimestamp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RtcpSenderInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $mswTimestamp = this.getMswTimestamp();
        result = result * 59 + (int)($mswTimestamp >>> 32 ^ $mswTimestamp);
        long $lswTimestamp = this.getLswTimestamp();
        result = result * 59 + (int)($lswTimestamp >>> 32 ^ $lswTimestamp);
        long $senderPacketCount = this.getSenderPacketCount();
        result = result * 59 + (int)($senderPacketCount >>> 32 ^ $senderPacketCount);
        long $senderOctetCount = this.getSenderOctetCount();
        result = result * 59 + (int)($senderOctetCount >>> 32 ^ $senderOctetCount);
        LocalDateTime $ntpTimestamp = this.getNtpTimestamp();
        result = result * 59 + ($ntpTimestamp == null ? 43 : ((Object)$ntpTimestamp).hashCode());
        LocalDateTime $rtpTimestamp = this.getRtpTimestamp();
        result = result * 59 + ($rtpTimestamp == null ? 43 : ((Object)$rtpTimestamp).hashCode());
        return result;
    }

    public String toString() {
        return "RtcpSenderInfo(mswTimestamp=" + this.getMswTimestamp() + ", lswTimestamp=" + this.getLswTimestamp() + ", ntpTimestamp=" + this.getNtpTimestamp() + ", rtpTimestamp=" + this.getRtpTimestamp() + ", senderPacketCount=" + this.getSenderPacketCount() + ", senderOctetCount=" + this.getSenderOctetCount() + ")";
    }
}

