/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtp.model.payload;

import com.github.xingshuangs.iot.protocol.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.protocol.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluHeader;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluSingle;

public class H264NaluStapSingle
extends H264NaluSingle {
    private int size;

    @Override
    public int byteArrayLength() {
        return this.header.byteArrayLength() + 2 + this.payload.length;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(this.byteArrayLength()).putShort(this.size).putBytes(this.header.toByteArray()).putBytes(this.payload).getData();
    }

    public static H264NaluStapSingle fromBytes(byte[] data) {
        return H264NaluStapSingle.fromBytes(data, 0);
    }

    public static H264NaluStapSingle fromBytes(byte[] data, int offset) {
        if (data.length < 3) {
            throw new IndexOutOfBoundsException("\u89e3\u6790H264NaluStapSingle\u65f6\uff0c\u5b57\u8282\u6570\u7ec4\u957f\u5ea6\u4e0d\u591f");
        }
        int index = offset;
        H264NaluStapSingle res = new H264NaluStapSingle();
        res.size = ByteReadBuff.newInstance(data, index).getUInt16();
        res.header = H264NaluHeader.fromBytes(data, index += 2);
        res.payload = ByteReadBuff.newInstance(data, index += res.header.byteArrayLength()).getBytes(res.size);
        return res;
    }
}

