/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtsp.model;

import com.github.xingshuangs.iot.exceptions.RtspCommException;
import com.github.xingshuangs.iot.protocol.rtsp.model.RtspDescribeResponse;
import com.github.xingshuangs.iot.protocol.rtsp.model.RtspGetParameterResponse;
import com.github.xingshuangs.iot.protocol.rtsp.model.RtspMessageRequest;
import com.github.xingshuangs.iot.protocol.rtsp.model.RtspMessageResponse;
import com.github.xingshuangs.iot.protocol.rtsp.model.RtspOptionResponse;
import com.github.xingshuangs.iot.protocol.rtsp.model.RtspPauseResponse;
import com.github.xingshuangs.iot.protocol.rtsp.model.RtspPlayResponse;
import com.github.xingshuangs.iot.protocol.rtsp.model.RtspSetParameterResponse;
import com.github.xingshuangs.iot.protocol.rtsp.model.RtspSetupResponse;
import com.github.xingshuangs.iot.protocol.rtsp.model.RtspTeardownResponse;

public class RtspMessageResponseBuilder {
    private RtspMessageResponseBuilder() {
    }

    public static RtspMessageResponse fromString(String src, RtspMessageRequest request) {
        switch (request.getMethod()) {
            case OPTIONS: {
                return RtspOptionResponse.fromHeaderString(src);
            }
            case DESCRIBE: {
                return RtspDescribeResponse.fromHeaderString(src);
            }
            case SETUP: {
                return RtspSetupResponse.fromHeaderString(src);
            }
            case PLAY: {
                return RtspPlayResponse.fromHeaderString(src);
            }
            case PAUSE: {
                return RtspPauseResponse.fromHeaderString(src);
            }
            case TEARDOWN: {
                return RtspTeardownResponse.fromHeaderString(src);
            }
            case GET_PARAMETER: {
                return RtspGetParameterResponse.fromHeaderString(src);
            }
            case SET_PARAMETER: {
                return RtspSetParameterResponse.fromHeaderString(src);
            }
        }
        throw new RtspCommException(String.format("\u672a\u5b9e\u73b0\u5bf9\u8be5Method[%s]\u7684\u6570\u636e\u89e3\u6790", request.getMethod().getCode()));
    }
}

