/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtsp.model;

import com.github.xingshuangs.iot.protocol.rtsp.authentication.AbstractAuthenticator;
import com.github.xingshuangs.iot.protocol.rtsp.enums.ERtspContentType;
import com.github.xingshuangs.iot.protocol.rtsp.enums.ERtspMethod;
import com.github.xingshuangs.iot.protocol.rtsp.model.RtspMessageRequest;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class RtspSetParameterRequest
extends RtspMessageRequest {
    private final Map<String, String> parameterMap = new LinkedHashMap<String, String>();

    public RtspSetParameterRequest(URI uri, String session) {
        super(ERtspMethod.SET_PARAMETER, uri, session);
    }

    public RtspSetParameterRequest(URI uri, String session, AbstractAuthenticator authenticator) {
        super(ERtspMethod.SET_PARAMETER, uri, session, authenticator);
    }

    public void addParameter(String name, String value) {
        this.parameterMap.put(name, value);
    }

    public void removeParameter(String name) {
        this.parameterMap.remove(name);
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameterMap);
    }

    @Override
    protected void addEntityHeader(StringBuilder sb) {
        if (!this.parameterMap.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            this.parameterMap.forEach((key, value) -> stringBuilder.append((String)key).append(": ").append((String)value).append("\r\n"));
            String content = stringBuilder.toString();
            sb.append("Content-Type").append(": ").append(ERtspContentType.PARAMETER.getCode()).append("\r\n");
            sb.append("Content-Length").append(": ").append(content.length()).append("\r\n");
        }
    }

    @Override
    protected void addMessageBody(StringBuilder sb) {
        if (!this.parameterMap.isEmpty()) {
            this.parameterMap.forEach((key, value) -> sb.append((String)key).append(": ").append((String)value).append("\r\n"));
        }
    }

    public Map<String, String> getParameterMap() {
        return this.parameterMap;
    }
}

