/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtsp.model.base;

public class RtspSessionInfo {
    private String sessionId;
    private int timeout;

    public static RtspSessionInfo fromString(String src) {
        if (src == null || src.equals("")) {
            throw new IllegalArgumentException("RtspSessionInfo\u90e8\u5206\u6570\u636e\u89e3\u6790\u9519\u8bef");
        }
        RtspSessionInfo sessionInfo = new RtspSessionInfo();
        int commaIndex = src.indexOf(";");
        sessionInfo.sessionId = commaIndex != -1 ? src.substring(0, commaIndex) : src;
        int equalIndex = src.indexOf("=");
        if (equalIndex != -1) {
            sessionInfo.timeout = Integer.parseInt(src.substring(equalIndex + 1)) * 1000;
        }
        return sessionInfo;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtspSessionInfo)) {
            return false;
        }
        RtspSessionInfo other = (RtspSessionInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        String this$sessionId = this.getSessionId();
        String other$sessionId = other.getSessionId();
        return !(this$sessionId == null ? other$sessionId != null : !this$sessionId.equals(other$sessionId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RtspSessionInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTimeout();
        String $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : $sessionId.hashCode());
        return result;
    }

    public String toString() {
        return "RtspSessionInfo(sessionId=" + this.getSessionId() + ", timeout=" + this.getTimeout() + ")";
    }
}

