/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtsp.model.base;

import com.github.xingshuangs.iot.exceptions.RtspCommException;
import com.github.xingshuangs.iot.protocol.rtsp.model.base.RtspClientPortTransport;
import com.github.xingshuangs.iot.protocol.rtsp.model.base.RtspInterleavedTransport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class RtspTransport {
    protected String protocol = "";
    protected String castMode = "";
    protected String ssrc = "";
    protected String mode = "";

    public static RtspTransport fromString(String src) {
        if (src == null || src.equals("")) {
            throw new IllegalArgumentException("RtspTransport\u90e8\u5206\u6570\u636e\u89e3\u6790\u9519\u8bef");
        }
        if (src.contains("interleaved")) {
            return RtspInterleavedTransport.fromString(src);
        }
        return RtspClientPortTransport.fromString(src);
    }

    protected Map<String, String> getMap(String[] data) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (String item : data) {
            int index = item.indexOf("=");
            if (index < 0) continue;
            res.put(item.substring(0, index).trim(), item.substring(index + 1).trim());
        }
        return res;
    }

    public String toString() {
        if (this.protocol == null || this.protocol.equals("")) {
            throw new RtspCommException("RtspTransport\u7684protocol\u5f02\u5e38");
        }
        if (this.castMode == null || this.castMode.equals("")) {
            throw new RtspCommException("RtspTransport\u7684castMode\u5f02\u5e38");
        }
        ArrayList<String> res = new ArrayList<String>();
        res.add(this.protocol);
        res.add(this.castMode);
        if (this.ssrc != null && !this.ssrc.equals("")) {
            res.add(String.format("ssrc=%s", this.ssrc));
        }
        if (this.mode != null && !this.mode.equals("")) {
            res.add(String.format("mode=\"%s\"", this.mode));
        }
        return String.join((CharSequence)";", res);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getCastMode() {
        return this.castMode;
    }

    public String getSsrc() {
        return this.ssrc;
    }

    public String getMode() {
        return this.mode;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setCastMode(String castMode) {
        this.castMode = castMode;
    }

    public void setSsrc(String ssrc) {
        this.ssrc = ssrc;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtspTransport)) {
            return false;
        }
        RtspTransport other = (RtspTransport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$protocol = this.getProtocol();
        String other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        String this$castMode = this.getCastMode();
        String other$castMode = other.getCastMode();
        if (this$castMode == null ? other$castMode != null : !this$castMode.equals(other$castMode)) {
            return false;
        }
        String this$ssrc = this.getSsrc();
        String other$ssrc = other.getSsrc();
        if (this$ssrc == null ? other$ssrc != null : !this$ssrc.equals(other$ssrc)) {
            return false;
        }
        String this$mode = this.getMode();
        String other$mode = other.getMode();
        return !(this$mode == null ? other$mode != null : !this$mode.equals(other$mode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RtspTransport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        String $castMode = this.getCastMode();
        result = result * 59 + ($castMode == null ? 43 : $castMode.hashCode());
        String $ssrc = this.getSsrc();
        result = result * 59 + ($ssrc == null ? 43 : $ssrc.hashCode());
        String $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
        return result;
    }
}

