/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtsp.service;

import com.github.xingshuangs.iot.protocol.common.IObjectByteArray;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4Header;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4MdatBox;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4MoofBox;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4SampleData;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4TrackInfo;
import com.github.xingshuangs.iot.protocol.rtp.enums.EFrameType;
import com.github.xingshuangs.iot.protocol.rtp.enums.EH264NaluType;
import com.github.xingshuangs.iot.protocol.rtp.model.frame.H264VideoFrame;
import com.github.xingshuangs.iot.protocol.rtsp.model.sdp.RtspTrackInfo;
import com.github.xingshuangs.iot.protocol.rtsp.service.RtspClient;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtspFMp4Proxy {
    private static final Logger log = LoggerFactory.getLogger(RtspFMp4Proxy.class);
    private final Object objLock = new Object();
    private final RtspClient client;
    private RtspTrackInfo trackInfo;
    private long sequenceNumber = 1L;
    private final ConcurrentLinkedQueue<IObjectByteArray> buffers = new ConcurrentLinkedQueue();
    private Consumer<byte[]> fmp4DataHandle;
    private Consumer<String> codecHandle;
    private Runnable destroyHandle;
    private boolean terminal = false;
    private Mp4Header mp4Header;
    private Mp4TrackInfo mp4TrackInfo;
    private boolean asyncSend = false;
    private H264VideoFrame lastFrame;
    private final List<H264VideoFrame> gop = new ArrayList<H264VideoFrame>();
    private CompletableFuture<Void> future;
    private ExecutorService executorService;

    public Mp4Header getMp4Header() {
        return this.mp4Header;
    }

    public Mp4TrackInfo getMp4TrackInfo() {
        return this.mp4TrackInfo;
    }

    public void onFmp4DataHandle(Consumer<byte[]> fmp4DataHandle) {
        this.fmp4DataHandle = fmp4DataHandle;
    }

    public void onCodecHandle(Consumer<String> codecHandle) {
        this.codecHandle = codecHandle;
    }

    public void onDestroyHandle(Runnable destroyHandle) {
        this.destroyHandle = destroyHandle;
    }

    public RtspFMp4Proxy(RtspClient client) {
        this(client, false);
    }

    public RtspFMp4Proxy(RtspClient client, boolean asyncSend) {
        this.client = client;
        this.client.onFrameHandle(x -> {
            H264VideoFrame f = (H264VideoFrame)x;
            this.initHeaderHandle();
            this.frameHandle(f);
        });
        this.client.onDestroyHandle(() -> {
            if (this.destroyHandle != null) {
                this.destroyHandle.run();
            }
        });
        this.asyncSend = asyncSend;
        if (this.asyncSend) {
            this.executorService = Executors.newSingleThreadExecutor();
            this.future = CompletableFuture.runAsync(this::executeHandle, this.executorService);
        }
    }

    private void initHeaderHandle() {
        if (this.trackInfo == null) {
            this.trackInfo = this.client.getTrackInfo();
            log.debug(this.trackInfo.toString());
            if (this.codecHandle != null) {
                this.codecHandle.accept(this.trackInfo.getCodec());
            }
            this.mp4TrackInfo = this.toMp4TrackInfo(this.trackInfo);
            this.mp4Header = new Mp4Header(this.mp4TrackInfo);
            this.addFMp4Data(this.mp4Header);
        }
    }

    private void frameHandle(H264VideoFrame frame) {
        if (frame.getFrameType() == EFrameType.AUDIO) {
            return;
        }
        if (frame.getNaluType() == EH264NaluType.PPS || frame.getNaluType() == EH264NaluType.SPS || frame.getNaluType() == EH264NaluType.SEI) {
            return;
        }
        this.gop.add(frame);
        if (this.gop.size() < 10) {
            return;
        }
        this.gop.sort((a, b) -> (int)(a.getTimestamp() - b.getTimestamp()));
        H264VideoFrame videoFrame = this.gop.remove(0);
        if (this.lastFrame == null) {
            this.lastFrame = videoFrame;
        }
        if (this.lastFrame.getTimestamp() > videoFrame.getTimestamp()) {
            log.warn("\u51fa\u73b0\u4e00\u5e27\u6570\u636e\u65f6\u95f4\u6233\u5c0f\u4e8e\u4e4b\u524d\u7684\u4e00\u5e27\u7684\u65f6\u95f4\u6233");
        }
        this.lastFrame = videoFrame;
        Mp4SampleData sampleData = new Mp4SampleData();
        sampleData.setData(videoFrame.getFrameSegment());
        sampleData.setTimestamp(videoFrame.getTimestamp());
        sampleData.getFlags().setDependedOn(videoFrame.getNaluType() == EH264NaluType.IDR_SLICE ? 2 : 1);
        sampleData.getFlags().setIsNonSync(videoFrame.getNaluType() == EH264NaluType.IDR_SLICE ? 0 : 1);
        if (videoFrame.getNaluType() == EH264NaluType.IDR_SLICE) {
            if (!this.mp4TrackInfo.getSampleData().isEmpty()) {
                this.addSampleData();
            }
            this.mp4TrackInfo.getSampleData().add(sampleData);
            this.addSampleData();
        } else {
            this.mp4TrackInfo.getSampleData().add(sampleData);
            if (this.mp4TrackInfo.getSampleData().size() >= 5) {
                this.addSampleData();
            }
        }
    }

    private void addSampleData() {
        Mp4SampleData first = this.mp4TrackInfo.getSampleData().get(0);
        this.addFMp4Data(new Mp4MoofBox(this.sequenceNumber, first.getTimestamp(), this.mp4TrackInfo));
        this.addFMp4Data(new Mp4MdatBox(this.mp4TrackInfo.totalSampleData()));
        this.mp4TrackInfo = this.toMp4TrackInfo(this.trackInfo);
        ++this.sequenceNumber;
    }

    private Mp4TrackInfo toMp4TrackInfo(RtspTrackInfo track) {
        Mp4TrackInfo info = new Mp4TrackInfo();
        info.setId(track.getId());
        info.setType(track.getType());
        info.setCodec(track.getCodec());
        info.setTimescale(track.getTimescale());
        info.setDuration(track.getDuration());
        info.setWidth(track.getWidth());
        info.setHeight(track.getHeight());
        info.setSps(track.getSps());
        info.setPps(track.getPps());
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFMp4Data(IObjectByteArray iObjectByteArray) {
        if (this.asyncSend) {
            this.buffers.offer(iObjectByteArray);
            Object object = this.objLock;
            synchronized (object) {
                this.objLock.notifyAll();
            }
        } else if (this.fmp4DataHandle != null) {
            this.fmp4DataHandle.accept(iObjectByteArray.toByteArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeHandle() {
        log.debug("\u5f00\u542f\u4ee3\u7406\u670d\u52a1\u7aef\u53d1\u9001FMp4\u5b57\u8282\u6570\u636e\u7684\u5f02\u6b65\u7ebf\u7a0b");
        while (!this.terminal) {
            while (this.buffers.isEmpty() && !this.terminal) {
                Object object = this.objLock;
                synchronized (object) {
                    try {
                        this.objLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            int size = this.buffers.size();
            for (int i = 0; i < size; ++i) {
                IObjectByteArray pop = this.buffers.poll();
                if (this.fmp4DataHandle == null || pop == null) continue;
                try {
                    this.fmp4DataHandle.accept(pop.toByteArray());
                    continue;
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        log.debug("\u5173\u95ed\u4ee3\u7406\u670d\u52a1\u7aef\u53d1\u9001FMp4\u5b57\u8282\u6570\u636e\u7684\u5f02\u6b65\u7ebf\u7a0b");
    }

    public CompletableFuture<Void> start() {
        log.info("\u5f00\u542fFMp4\u4ee3\u7406\u670d\u52a1\u7aef\uff0c\u6a21\u5f0f[{}]\uff0c\u5730\u5740[{}]", (Object)(this.asyncSend ? "\u5f02\u6b65" : "\u540c\u6b65"), (Object)this.client.getUri());
        return this.client.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        if (this.asyncSend) {
            this.terminal = true;
            Object object = this.objLock;
            synchronized (object) {
                this.objLock.notifyAll();
            }
            if (this.future != null && !this.future.isDone()) {
                this.future.join();
            }
        }
        this.client.stop();
        log.info("\u5173\u95edFMp4\u4ee3\u7406\u670d\u52a1\u7aef\uff0c\u5730\u5740[{}]", (Object)this.client.getUri());
    }
}

