/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.enums;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public enum EFileBlockType {
    OB("08"),
    CMOD("09"),
    DB("0A"),
    SDB("0B"),
    FC("0C"),
    SFC("0D"),
    FB("0E"),
    SFB("0F");

    private static Map<String, EFileBlockType> map;
    private final String code;
    private final byte[] byteArray;

    public static EFileBlockType from(String data) {
        if (map == null) {
            map = new HashMap<String, EFileBlockType>();
            for (EFileBlockType item : EFileBlockType.values()) {
                map.put(item.code, item);
            }
        }
        return map.get(data);
    }

    private EFileBlockType(String code) {
        this.code = code;
        this.byteArray = code.getBytes(StandardCharsets.US_ASCII);
    }

    public String getCode() {
        return this.code;
    }

    public byte[] getByteArray() {
        return this.byteArray;
    }
}

