/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.model;

import com.github.xingshuangs.iot.protocol.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.protocol.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.s7.enums.EErrorClass;
import com.github.xingshuangs.iot.protocol.s7.enums.EMessageType;
import com.github.xingshuangs.iot.protocol.s7.model.Header;

public class AckHeader
extends Header {
    public static final int BYTE_LENGTH = 12;
    private EErrorClass errorClass = EErrorClass.NO_ERROR;
    private int errorCode = 0;

    @Override
    public int byteArrayLength() {
        return 12;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(12).putBytes(super.toByteArray()).putByte(this.errorClass.getCode()).putByte(this.errorCode).getData();
    }

    public static AckHeader fromBytes(byte[] data) {
        if (data.length < 12) {
            throw new IndexOutOfBoundsException("\u89e3\u6790header\u65f6\uff0c\u5b57\u8282\u6570\u7ec4\u957f\u5ea6\u4e0d\u591f");
        }
        ByteReadBuff buff = new ByteReadBuff(data);
        AckHeader header = new AckHeader();
        header.protocolId = buff.getByte();
        header.messageType = EMessageType.from(buff.getByte());
        header.reserved = buff.getUInt16();
        header.pduReference = buff.getUInt16();
        header.parameterLength = buff.getUInt16();
        header.dataLength = buff.getUInt16();
        header.errorClass = EErrorClass.from(buff.getByte());
        header.errorCode = buff.getUInt16(10);
        return header;
    }

    public static AckHeader createDefault(Header request, EErrorClass errorClass, int errorCode) {
        AckHeader header = new AckHeader();
        header.protocolId = request.protocolId;
        header.messageType = EMessageType.ACK_DATA;
        header.reserved = request.reserved;
        header.pduReference = request.pduReference;
        header.parameterLength = request.parameterLength;
        header.dataLength = request.dataLength;
        header.errorClass = errorClass;
        header.errorCode = errorCode;
        return header;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AckHeader)) {
            return false;
        }
        AckHeader other = (AckHeader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getErrorCode() != other.getErrorCode()) {
            return false;
        }
        EErrorClass this$errorClass = this.getErrorClass();
        EErrorClass other$errorClass = other.getErrorClass();
        return !(this$errorClass == null ? other$errorClass != null : !((Object)((Object)this$errorClass)).equals((Object)other$errorClass));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AckHeader;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getErrorCode();
        EErrorClass $errorClass = this.getErrorClass();
        result = result * 59 + ($errorClass == null ? 43 : ((Object)((Object)$errorClass)).hashCode());
        return result;
    }

    public EErrorClass getErrorClass() {
        return this.errorClass;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorClass(EErrorClass errorClass) {
        this.errorClass = errorClass;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    @Override
    public String toString() {
        return "AckHeader(errorClass=" + (Object)((Object)this.getErrorClass()) + ", errorCode=" + this.getErrorCode() + ")";
    }
}

