/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.model;

import com.github.xingshuangs.iot.exceptions.S7CommException;
import com.github.xingshuangs.iot.protocol.s7.enums.EPduType;
import com.github.xingshuangs.iot.protocol.s7.model.COTP;
import com.github.xingshuangs.iot.protocol.s7.model.COTPConnection;
import com.github.xingshuangs.iot.protocol.s7.model.COTPData;
import com.github.xingshuangs.iot.utils.ByteUtil;
import java.util.Arrays;

public class COTPBuilder {
    private COTPBuilder() {
    }

    public static COTP fromBytes(byte[] data) {
        int length = ByteUtil.toUInt8(data[0]);
        byte[] cotpBytes = Arrays.copyOfRange(data, 0, length + 1);
        EPduType pduType = EPduType.from(cotpBytes[1]);
        switch (pduType) {
            case CONNECT_REQUEST: 
            case CONNECT_CONFIRM: 
            case DISCONNECT_REQUEST: 
            case DISCONNECT_CONFIRM: {
                return COTPConnection.fromBytes(cotpBytes);
            }
            case REJECT: {
                return null;
            }
            case DT_DATA: {
                return COTPData.fromBytes(cotpBytes);
            }
        }
        throw new S7CommException("COTP\u7684pduType\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u89e3\u6790");
    }
}

