/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.model;

import com.github.xingshuangs.iot.exceptions.S7CommException;
import com.github.xingshuangs.iot.protocol.common.IObjectByteArray;
import com.github.xingshuangs.iot.protocol.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.protocol.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.s7.enums.EPduType;
import com.github.xingshuangs.iot.protocol.s7.model.COTP;
import com.github.xingshuangs.iot.utils.BooleanUtil;

public class COTPData
extends COTP
implements IObjectByteArray {
    public static final int BYTE_LENGTH = 3;
    private int tpduNumber = 0;
    private boolean lastDataUnit = true;

    @Override
    public int byteArrayLength() {
        return 3;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(3).putByte(this.length).putByte(this.pduType.getCode()).putByte((byte)(BooleanUtil.setBit((byte)0, 7, this.lastDataUnit) | this.tpduNumber & 0xFF)).getData();
    }

    public static COTPData fromBytes(byte[] data) {
        if (data.length < 3) {
            throw new S7CommException("COTPData\u6570\u636e\u5b57\u8282\u957f\u5ea6\u4e0d\u591f\uff0c\u65e0\u6cd5\u89e3\u6790");
        }
        ByteReadBuff buff = new ByteReadBuff(data);
        COTPData cotpData = new COTPData();
        cotpData.length = buff.getByteToInt();
        cotpData.pduType = EPduType.from(buff.getByte());
        cotpData.tpduNumber = buff.getByte() & 0x7F;
        cotpData.lastDataUnit = buff.getBoolean(2, 7);
        return cotpData;
    }

    public static COTPData createDefault() {
        COTPData connection = new COTPData();
        connection.length = 2;
        connection.pduType = EPduType.DT_DATA;
        connection.tpduNumber = 0;
        connection.lastDataUnit = true;
        return connection;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof COTPData)) {
            return false;
        }
        COTPData other = (COTPData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getTpduNumber() != other.getTpduNumber()) {
            return false;
        }
        return this.isLastDataUnit() == other.isLastDataUnit();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof COTPData;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getTpduNumber();
        result = result * 59 + (this.isLastDataUnit() ? 79 : 97);
        return result;
    }

    public int getTpduNumber() {
        return this.tpduNumber;
    }

    public boolean isLastDataUnit() {
        return this.lastDataUnit;
    }

    public void setTpduNumber(int tpduNumber) {
        this.tpduNumber = tpduNumber;
    }

    public void setLastDataUnit(boolean lastDataUnit) {
        this.lastDataUnit = lastDataUnit;
    }

    @Override
    public String toString() {
        return "COTPData(tpduNumber=" + this.getTpduNumber() + ", lastDataUnit=" + this.isLastDataUnit() + ")";
    }
}

