/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.model;

import com.github.xingshuangs.iot.exceptions.S7CommException;
import com.github.xingshuangs.iot.protocol.common.IObjectByteArray;
import com.github.xingshuangs.iot.protocol.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.protocol.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.s7.enums.EDataVariableType;
import com.github.xingshuangs.iot.protocol.s7.enums.EReturnCode;
import com.github.xingshuangs.iot.protocol.s7.model.ReturnItem;
import com.github.xingshuangs.iot.utils.BooleanUtil;
import java.util.Arrays;

public class DataItem
extends ReturnItem
implements IObjectByteArray {
    private EDataVariableType variableType = EDataVariableType.BYTE_WORD_DWORD;
    private int count = 0;
    private byte[] data = new byte[0];

    @Override
    public int byteArrayLength() {
        return 4 + this.data.length;
    }

    @Override
    public byte[] toByteArray() {
        int length = 4 + this.data.length;
        ByteWriteBuff buff = ByteWriteBuff.newInstance(length).putByte(this.returnCode.getCode()).putByte(this.variableType.getCode());
        switch (this.variableType) {
            case NULL: 
            case BYTE_WORD_DWORD: 
            case INTEGER: {
                buff.putShort(this.count * 8);
                break;
            }
            case BIT: 
            case DINTEGER: 
            case REAL: 
            case OCTET_STRING: {
                buff.putShort(this.count);
                break;
            }
            default: {
                throw new S7CommException("\u65e0\u6cd5\u8bc6\u522b\u6570\u636e\u7c7b\u578b");
            }
        }
        buff.putBytes(this.data);
        return buff.getData();
    }

    public DataItem copy() {
        DataItem dataItem = new DataItem();
        dataItem.returnCode = this.returnCode;
        dataItem.variableType = this.variableType;
        dataItem.count = this.count;
        dataItem.data = this.data;
        return dataItem;
    }

    public static DataItem fromBytes(byte[] data) {
        ByteReadBuff buff = new ByteReadBuff(data);
        DataItem dataItem = new DataItem();
        dataItem.returnCode = EReturnCode.from(buff.getByte());
        dataItem.variableType = EDataVariableType.from(buff.getByte());
        switch (dataItem.variableType) {
            case NULL: 
            case BYTE_WORD_DWORD: 
            case INTEGER: {
                dataItem.count = buff.getUInt16() / 8;
                break;
            }
            case BIT: 
            case DINTEGER: 
            case REAL: 
            case OCTET_STRING: {
                dataItem.count = buff.getUInt16();
                break;
            }
            default: {
                throw new S7CommException("\u65e0\u6cd5\u8bc6\u522b\u6570\u636e\u7c7b\u578b");
            }
        }
        if (dataItem.variableType != EDataVariableType.NULL) {
            dataItem.data = buff.getBytes(dataItem.count);
        }
        return dataItem;
    }

    public static DataItem createReqByByte(byte data) {
        return DataItem.createReqByByte(new byte[]{data});
    }

    public static DataItem createReqByByte(byte[] data) {
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("data\u6570\u636e\u4e0d\u80fd\u4e3anull");
        }
        DataItem dataItem = new DataItem();
        dataItem.setReturnCode(EReturnCode.RESERVED);
        dataItem.setVariableType(EDataVariableType.BYTE_WORD_DWORD);
        dataItem.setCount(data.length);
        dataItem.setData(data);
        return dataItem;
    }

    public static DataItem createReqByBoolean(boolean data) {
        DataItem dataItem = new DataItem();
        dataItem.setReturnCode(EReturnCode.RESERVED);
        dataItem.setVariableType(EDataVariableType.BIT);
        dataItem.setCount(1);
        dataItem.setData(new byte[]{BooleanUtil.toByte(data)});
        return dataItem;
    }

    public static DataItem createReq(byte[] data, EDataVariableType dataVariableType) {
        DataItem dataItem = new DataItem();
        dataItem.setReturnCode(EReturnCode.RESERVED);
        dataItem.setVariableType(dataVariableType);
        dataItem.setCount(data.length);
        dataItem.setData(data);
        return dataItem;
    }

    public static DataItem createAckBy(byte[] data, EDataVariableType dataVariableType) {
        DataItem dataItem = new DataItem();
        dataItem.setReturnCode(EReturnCode.SUCCESS);
        dataItem.setVariableType(dataVariableType);
        dataItem.setCount(data.length);
        dataItem.setData(data);
        return dataItem;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataItem)) {
            return false;
        }
        DataItem other = (DataItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        EDataVariableType this$variableType = this.getVariableType();
        EDataVariableType other$variableType = other.getVariableType();
        if (this$variableType == null ? other$variableType != null : !((Object)((Object)this$variableType)).equals((Object)other$variableType)) {
            return false;
        }
        return Arrays.equals(this.getData(), other.getData());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DataItem;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getCount();
        EDataVariableType $variableType = this.getVariableType();
        result = result * 59 + ($variableType == null ? 43 : ((Object)((Object)$variableType)).hashCode());
        result = result * 59 + Arrays.hashCode(this.getData());
        return result;
    }

    public EDataVariableType getVariableType() {
        return this.variableType;
    }

    public int getCount() {
        return this.count;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setVariableType(EDataVariableType variableType) {
        this.variableType = variableType;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    @Override
    public String toString() {
        return "DataItem(variableType=" + (Object)((Object)this.getVariableType()) + ", count=" + this.getCount() + ", data=" + Arrays.toString(this.getData()) + ")";
    }
}

