/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.service;

import com.github.xingshuangs.iot.protocol.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.protocol.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.s7.enums.EArea;
import com.github.xingshuangs.iot.protocol.s7.enums.EDataVariableType;
import com.github.xingshuangs.iot.protocol.s7.enums.EDestinationFileSystem;
import com.github.xingshuangs.iot.protocol.s7.enums.EFileBlockType;
import com.github.xingshuangs.iot.protocol.s7.enums.ENckArea;
import com.github.xingshuangs.iot.protocol.s7.enums.ENckModule;
import com.github.xingshuangs.iot.protocol.s7.enums.EParamVariableType;
import com.github.xingshuangs.iot.protocol.s7.enums.EPlcType;
import com.github.xingshuangs.iot.protocol.s7.model.DataItem;
import com.github.xingshuangs.iot.protocol.s7.model.RequestItem;
import com.github.xingshuangs.iot.protocol.s7.model.RequestNckItem;
import com.github.xingshuangs.iot.protocol.s7.model.S7Data;
import com.github.xingshuangs.iot.protocol.s7.service.MultiAddressRead;
import com.github.xingshuangs.iot.protocol.s7.service.MultiAddressWrite;
import com.github.xingshuangs.iot.protocol.s7.service.PLCNetwork;
import com.github.xingshuangs.iot.protocol.s7.utils.AddressUtil;
import com.github.xingshuangs.iot.utils.BooleanUtil;
import com.github.xingshuangs.iot.utils.ByteUtil;
import com.github.xingshuangs.iot.utils.FloatUtil;
import com.github.xingshuangs.iot.utils.IntegerUtil;
import com.github.xingshuangs.iot.utils.ShortUtil;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class S7PLC
extends PLCNetwork {
    public static final int PORT = 102;
    public static final int DEFAULT_PDU_LENGTH = 240;
    public static final String IP = "127.0.0.1";

    public S7PLC() {
        this(EPlcType.S1200, IP, 102, 0, 1, 240);
    }

    public S7PLC(EPlcType plcType) {
        this(plcType, IP, 102, 0, 1, 240);
    }

    public S7PLC(EPlcType plcType, String ip) {
        this(plcType, ip, 102, 0, 1, 240);
    }

    public S7PLC(EPlcType plcType, String ip, int port) {
        this(plcType, ip, port, 0, 1, 240);
    }

    public S7PLC(EPlcType plcType, String ip, int port, int rack, int slot) {
        this(plcType, ip, port, rack, slot, 240);
    }

    public S7PLC(EPlcType plcType, String ip, int port, int rack, int slot, int pduLength) {
        super(ip, port);
        this.plcType = plcType;
        this.rack = rack;
        this.slot = slot;
        this.pduLength = pduLength;
    }

    public byte[] readRaw(EParamVariableType variableType, int count, EArea area, int dbNumber, int byteAddress, int bitAddress) {
        if (count <= 0) {
            throw new IllegalArgumentException("count<=0");
        }
        if (dbNumber < 0) {
            throw new IllegalArgumentException("dbNumber<0");
        }
        if (byteAddress < 0) {
            throw new IllegalArgumentException("byteAddress<0");
        }
        if (bitAddress < 0 || bitAddress > 7) {
            throw new IllegalArgumentException("bitAddress<0||bitAddress>7");
        }
        RequestItem requestItem = RequestItem.createByParams(variableType, count, area, dbNumber, byteAddress, bitAddress);
        DataItem dataItem = this.readS7Data(requestItem);
        return dataItem.getData();
    }

    public List<byte[]> readMultiByte(MultiAddressRead addressRead) {
        List<DataItem> dataItems = this.readS7Data(addressRead.getRequestItems());
        return dataItems.stream().map(DataItem::getData).collect(Collectors.toList());
    }

    public byte[] readByte(String address, int count) {
        DataItem dataItem = this.readS7Data(AddressUtil.parseByte(address, count));
        return dataItem.getData();
    }

    public byte readByte(String address) {
        return this.readByte(address, 1)[0];
    }

    public boolean readBoolean(String address) {
        DataItem dataItem = this.readS7Data(AddressUtil.parseBit(address));
        return BooleanUtil.getValue(dataItem.getData()[0], 0);
    }

    public List<Boolean> readBoolean(String ... address) {
        return this.readBoolean(Arrays.asList(address));
    }

    public List<Boolean> readBoolean(List<String> addresses) {
        List<RequestItem> requestItems = addresses.stream().map(AddressUtil::parseBit).collect(Collectors.toList());
        List<DataItem> dataItems = this.readS7Data(requestItems);
        return dataItems.stream().map(x -> BooleanUtil.getValue(x.getData()[0], 0)).collect(Collectors.toList());
    }

    public short readInt16(String address) {
        DataItem dataItem = this.readS7Data(AddressUtil.parseByte(address, 2));
        return ShortUtil.toInt16(dataItem.getData());
    }

    public List<Short> readInt16(String ... address) {
        return this.readInt16(Arrays.asList(address));
    }

    public List<Short> readInt16(List<String> addresses) {
        List<RequestItem> requestItems = addresses.stream().map(x -> AddressUtil.parseByte(x, 2)).collect(Collectors.toList());
        List<DataItem> dataItems = this.readS7Data(requestItems);
        return dataItems.stream().map(x -> ShortUtil.toInt16(x.getData())).collect(Collectors.toList());
    }

    public int readUInt16(String address) {
        DataItem dataItem = this.readS7Data(AddressUtil.parseByte(address, 2));
        return ShortUtil.toUInt16(dataItem.getData());
    }

    public List<Integer> readUInt16(String ... address) {
        return this.readUInt16(Arrays.asList(address));
    }

    public List<Integer> readUInt16(List<String> addresses) {
        List<RequestItem> requestItems = addresses.stream().map(x -> AddressUtil.parseByte(x, 2)).collect(Collectors.toList());
        List<DataItem> dataItems = this.readS7Data(requestItems);
        return dataItems.stream().map(x -> ShortUtil.toUInt16(x.getData())).collect(Collectors.toList());
    }

    public int readInt32(String address) {
        DataItem dataItem = this.readS7Data(AddressUtil.parseByte(address, 4));
        return IntegerUtil.toInt32(dataItem.getData());
    }

    public List<Integer> readInt32(String ... address) {
        return this.readInt32(Arrays.asList(address));
    }

    public List<Integer> readInt32(List<String> addresses) {
        List<RequestItem> requestItems = addresses.stream().map(x -> AddressUtil.parseByte(x, 4)).collect(Collectors.toList());
        List<DataItem> dataItems = this.readS7Data(requestItems);
        return dataItems.stream().map(x -> IntegerUtil.toInt32(x.getData())).collect(Collectors.toList());
    }

    public long readUInt32(String address) {
        DataItem dataItem = this.readS7Data(AddressUtil.parseByte(address, 4));
        return IntegerUtil.toUInt32(dataItem.getData());
    }

    public List<Long> readUInt32(String ... address) {
        return this.readUInt32(Arrays.asList(address));
    }

    public List<Long> readUInt32(List<String> addresses) {
        List<RequestItem> requestItems = addresses.stream().map(x -> AddressUtil.parseByte(x, 4)).collect(Collectors.toList());
        List<DataItem> dataItems = this.readS7Data(requestItems);
        return dataItems.stream().map(x -> IntegerUtil.toUInt32(x.getData())).collect(Collectors.toList());
    }

    public float readFloat32(String address) {
        DataItem dataItem = this.readS7Data(AddressUtil.parseByte(address, 4));
        return FloatUtil.toFloat32(dataItem.getData());
    }

    public List<Float> readFloat32(String ... address) {
        return this.readFloat32(Arrays.asList(address));
    }

    public List<Float> readFloat32(List<String> addresses) {
        List<RequestItem> requestItems = addresses.stream().map(x -> AddressUtil.parseByte(x, 4)).collect(Collectors.toList());
        List<DataItem> dataItems = this.readS7Data(requestItems);
        return dataItems.stream().map(x -> Float.valueOf(FloatUtil.toFloat32(x.getData()))).collect(Collectors.toList());
    }

    public double readFloat64(String address) {
        DataItem dataItem = this.readS7Data(AddressUtil.parseByte(address, 8));
        return FloatUtil.toFloat64(dataItem.getData());
    }

    public List<Double> readFloat64(String ... address) {
        return this.readFloat64(Arrays.asList(address));
    }

    public List<Double> readFloat64(List<String> addresses) {
        List<RequestItem> requestItems = addresses.stream().map(x -> AddressUtil.parseByte(x, 8)).collect(Collectors.toList());
        List<DataItem> dataItems = this.readS7Data(requestItems);
        return dataItems.stream().map(x -> FloatUtil.toFloat64(x.getData())).collect(Collectors.toList());
    }

    public String readString(String address) {
        int offset = this.plcType == EPlcType.S200_SMART ? 1 : 2;
        DataItem dataItem = this.readS7Data(AddressUtil.parseByte(address, offset));
        int length = ByteUtil.toUInt8(dataItem.getData(), offset - 1);
        dataItem = this.readS7Data(AddressUtil.parseByte(address, offset + length));
        return ByteUtil.toStr(dataItem.getData(), offset, length, Charset.forName("GB2312"));
    }

    public String readString(String address, int length) {
        if (length <= 0 || length > 254) {
            throw new IllegalArgumentException("length <= 0 || length > 254");
        }
        int offset = this.plcType == EPlcType.S200_SMART ? 1 : 2;
        DataItem dataItem = this.readS7Data(AddressUtil.parseByte(address, offset + length));
        int actLength = ByteUtil.toUInt8(dataItem.getData(), offset - 1);
        return ByteUtil.toStr(dataItem.getData(), offset, Math.min(actLength, length), Charset.forName("GB2312"));
    }

    public long readTime(String address) {
        return this.readUInt32(address);
    }

    public LocalDate readDate(String address) {
        int offset = this.readUInt16(address);
        return LocalDate.of(1990, 1, 1).plusDays(offset);
    }

    public LocalTime readTimeOfDay(String address) {
        long value = this.readUInt32(address);
        return LocalTime.ofSecondOfDay(value / 1000L);
    }

    public LocalDateTime readDTL(String address) {
        byte[] bytes = this.readByte(address, 12);
        ByteReadBuff buff = ByteReadBuff.newInstance(bytes);
        int year = buff.getUInt16();
        int month = buff.getByteToInt();
        int dayOfMonth = buff.getByteToInt();
        int week = buff.getByteToInt();
        int hour = buff.getByteToInt();
        int minute = buff.getByteToInt();
        int second = buff.getByteToInt();
        long nanoOfSecond = buff.getUInt32();
        return LocalDateTime.of(year, month, dayOfMonth, hour, minute, second, (int)nanoOfSecond);
    }

    public void writeRaw(EParamVariableType variableType, int count, EArea area, int dbNumber, int byteAddress, int bitAddress, EDataVariableType dataVariableType, byte[] data) {
        if (count <= 0) {
            throw new IllegalArgumentException("count<=0");
        }
        if (dbNumber < 0) {
            throw new IllegalArgumentException("dbNumber<0");
        }
        if (byteAddress < 0) {
            throw new IllegalArgumentException("byteAddress<0");
        }
        if (bitAddress < 0 || bitAddress > 7) {
            throw new IllegalArgumentException("bitAddress<0||bitAddress>7");
        }
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("data");
        }
        RequestItem requestItem = RequestItem.createByParams(variableType, count, area, dbNumber, byteAddress, bitAddress);
        DataItem dataItem = DataItem.createReq(data, dataVariableType);
        this.writeS7Data(requestItem, dataItem);
    }

    public void writeBoolean(String address, boolean data) {
        this.writeS7Data(AddressUtil.parseBit(address), DataItem.createReqByBoolean(data));
    }

    public void writeByte(String address, byte data) {
        this.writeS7Data(AddressUtil.parseByte(address, 1), DataItem.createReqByByte(data));
    }

    public void writeByte(String address, byte[] data) {
        this.writeS7Data(AddressUtil.parseByte(address, data.length), DataItem.createReqByByte(data));
    }

    public void writeUInt16(String address, int data) {
        this.writeByte(address, ShortUtil.toByteArray(data));
    }

    public void writeInt16(String address, short data) {
        this.writeByte(address, ShortUtil.toByteArray(data));
    }

    public void writeUInt32(String address, long data) {
        this.writeByte(address, IntegerUtil.toByteArray(data));
    }

    public void writeInt32(String address, int data) {
        this.writeByte(address, IntegerUtil.toByteArray(data));
    }

    public void writeFloat32(String address, float data) {
        this.writeByte(address, FloatUtil.toByteArray(data));
    }

    public void writeFloat64(String address, double data) {
        this.writeByte(address, FloatUtil.toByteArray(data));
    }

    public void writeMultiData(MultiAddressWrite addressWrite) {
        this.writeS7Data(addressWrite.getRequestItems(), addressWrite.getDataItems());
    }

    public void writeString(String address, String data) {
        if (data.length() == 0) {
            throw new IllegalArgumentException("data\u5b57\u7b26\u4e32\u53c2\u6570\u957f\u5ea6\u4e3a0");
        }
        int offset = this.plcType == EPlcType.S200_SMART ? 0 : 1;
        byte[] dataBytes = data.getBytes(Charset.forName("GB2312"));
        byte[] tmp = new byte[1 + dataBytes.length];
        tmp[0] = ByteUtil.toByte(dataBytes.length);
        System.arraycopy(dataBytes, 0, tmp, 1, dataBytes.length);
        RequestItem requestItem = AddressUtil.parseByte(address, tmp.length);
        requestItem.setByteAddress(requestItem.getByteAddress() + offset);
        this.writeS7Data(requestItem, DataItem.createReqByByte(tmp));
    }

    public void writeTime(String address, long time) {
        this.writeUInt32(address, time);
    }

    public void writeDate(String address, LocalDate date) {
        LocalDate start = LocalDate.of(1990, 1, 1);
        long value = date.toEpochDay() - start.toEpochDay();
        this.writeUInt16(address, (int)value);
    }

    public void writeTimeOfDay(String address, LocalTime time) {
        int value = time.toSecondOfDay();
        this.writeUInt32(address, (long)value * 1000L);
    }

    public void writeDTL(String address, LocalDateTime dateTime) {
        byte[] data = ByteWriteBuff.newInstance(12).putShort(dateTime.getYear()).putByte(dateTime.getMonthValue()).putByte(dateTime.getDayOfMonth()).putByte(dateTime.getDayOfWeek().getValue()).putByte(dateTime.getHour()).putByte(dateTime.getMinute()).putByte(dateTime.getSecond()).putInteger(dateTime.getNano()).getData();
        this.writeByte(address, data);
    }

    public void hotRestart() {
        this.readFromServerByPersistence(S7Data.createHotRestart());
    }

    public void coldRestart() {
        this.readFromServerByPersistence(S7Data.createColdRestart());
    }

    public void plcStop() {
        this.readFromServerByPersistence(S7Data.createPlcStop());
    }

    public void copyRamToRom() {
        this.readFromServerByPersistence(S7Data.createCopyRamToRom());
    }

    public void compress() {
        this.readFromServerByPersistence(S7Data.createCompress());
    }

    public void insert(EFileBlockType blockType, int blockNumber) {
        this.readFromServerByPersistence(S7Data.createInsert(blockType, blockNumber, EDestinationFileSystem.P));
    }

    public String readCncId() {
        RequestNckItem requestNckItem = new RequestNckItem(ENckArea.N_NCK, 1, 18030, 1, ENckModule.M, 1);
        DataItem dataItem = this.readS7NckData(requestNckItem);
        return ByteReadBuff.newInstance(dataItem.getData(), true).getString(dataItem.getCount()).trim();
    }

    public String readCncVersion() {
        RequestNckItem requestNckItem = new RequestNckItem(ENckArea.N_NCK, 1, 18040, 1, ENckModule.M, 1);
        DataItem dataItem = this.readS7NckData(requestNckItem);
        return ByteReadBuff.newInstance(dataItem.getData(), true).getString(dataItem.getCount()).trim();
    }

    public String readCncType1() {
        RequestNckItem requestNckItem = new RequestNckItem(ENckArea.N_NCK, 1, 18040, 2, ENckModule.M, 1);
        DataItem dataItem = this.readS7NckData(requestNckItem);
        return ByteReadBuff.newInstance(dataItem.getData(), true).getString(dataItem.getCount()).trim();
    }

    public String readCncManufactureDate() {
        RequestNckItem requestNckItem = new RequestNckItem(ENckArea.N_NCK, 1, 18040, 3, ENckModule.M, 1);
        DataItem dataItem = this.readS7NckData(requestNckItem);
        return ByteReadBuff.newInstance(dataItem.getData(), true).getString(dataItem.getCount()).trim();
    }

    public String readCncType() {
        RequestNckItem requestNckItem = new RequestNckItem(ENckArea.N_NCK, 1, 18040, 4, ENckModule.M, 1);
        DataItem dataItem = this.readS7NckData(requestNckItem);
        return ByteReadBuff.newInstance(dataItem.getData(), true).getString(dataItem.getCount()).trim();
    }

    public List<Double> readMachinePosition() {
        List<RequestNckItem> requestNckItems = IntStream.of(1, 2, 3, 4).mapToObj(x -> new RequestNckItem(ENckArea.C_CHANNEL, 1, 2, x, ENckModule.SMA, 1)).collect(Collectors.toList());
        List<DataItem> dataItems = this.readS7NckData(requestNckItems);
        return dataItems.stream().map(x -> ByteReadBuff.newInstance(x.getData(), true).getFloat64()).collect(Collectors.toList());
    }

    public List<Double> readRelativePosition() {
        List<RequestNckItem> requestNckItems = IntStream.of(1, 2, 3, 4).mapToObj(x -> new RequestNckItem(ENckArea.C_CHANNEL, 1, 25, x, ENckModule.SEGA, 1)).collect(Collectors.toList());
        List<DataItem> dataItems = this.readS7NckData(requestNckItems);
        return dataItems.stream().map(x -> ByteReadBuff.newInstance(x.getData(), true).getFloat64()).collect(Collectors.toList());
    }

    public List<Double> readRemainPosition() {
        List<RequestNckItem> requestNckItems = IntStream.of(1, 2, 3, 4).mapToObj(x -> new RequestNckItem(ENckArea.C_CHANNEL, 1, 3, x, ENckModule.SMA, 1)).collect(Collectors.toList());
        List<DataItem> dataItems = this.readS7NckData(requestNckItems);
        return dataItems.stream().map(x -> ByteReadBuff.newInstance(x.getData(), true).getFloat64()).collect(Collectors.toList());
    }

    public List<Double> readTWorkPiecePosition() {
        List<RequestNckItem> requestNckItems = IntStream.of(4, 5, 6).mapToObj(x -> new RequestNckItem(ENckArea.C_CHANNEL, 1, 1, x, ENckModule.FU, 1)).collect(Collectors.toList());
        List<DataItem> dataItems = this.readS7NckData(requestNckItems);
        return dataItems.stream().map(x -> ByteReadBuff.newInstance(x.getData(), true).getFloat64()).collect(Collectors.toList());
    }

    public int readToolRadiusCompensationNumber() {
        RequestNckItem requestNckItem = new RequestNckItem(ENckArea.C_CHANNEL, 1, 35, 1, ENckModule.S, 1);
        DataItem dataItem = this.readS7NckData(requestNckItem);
        return ByteReadBuff.newInstance(dataItem.getData(), true).getUInt16();
    }

    public int readToolNumber() {
        RequestNckItem requestNckItem = new RequestNckItem(ENckArea.C_CHANNEL, 1, 23, 1, ENckModule.S, 1);
        DataItem dataItem = this.readS7NckData(requestNckItem);
        return ByteReadBuff.newInstance(dataItem.getData(), true).getUInt16();
    }

    public double readActSpindleSpeed() {
        RequestNckItem item = new RequestNckItem(ENckArea.C_CHANNEL, 1, 2, 1, ENckModule.SSP, 1);
        DataItem dataItem = this.readS7NckData(item);
        return ByteReadBuff.newInstance(dataItem.getData(), true).getFloat64();
    }

    public double readSetSpindleSpeed() {
        RequestNckItem item = new RequestNckItem(ENckArea.N_NCK, 1, 3, 4, ENckModule.SSP, 1);
        DataItem dataItem = this.readS7NckData(item);
        return ByteReadBuff.newInstance(dataItem.getData(), true).getFloat64();
    }

    public double readSpindleRate() {
        RequestNckItem item = new RequestNckItem(ENckArea.C_CHANNEL, 1, 4, 1, ENckModule.SSP, 1);
        DataItem dataItem = this.readS7NckData(item);
        return ByteReadBuff.newInstance(dataItem.getData(), true).getFloat64();
    }

    public double readFeedRate() {
        RequestNckItem item = new RequestNckItem(ENckArea.C_CHANNEL, 1, 3, 1, ENckModule.S, 1);
        DataItem dataItem = this.readS7NckData(item);
        return ByteReadBuff.newInstance(dataItem.getData(), true).getFloat64();
    }

    public double readSetFeedRate() {
        RequestNckItem item = new RequestNckItem(ENckArea.C_CHANNEL, 1, 2, 1, ENckModule.S, 1);
        DataItem dataItem = this.readS7NckData(item);
        return ByteReadBuff.newInstance(dataItem.getData(), true).getFloat64();
    }

    public double readActFeedRate() {
        RequestNckItem item = new RequestNckItem(ENckArea.C_CHANNEL, 1, 1, 1, ENckModule.S, 1);
        DataItem dataItem = this.readS7NckData(item);
        return ByteReadBuff.newInstance(dataItem.getData(), true).getFloat64();
    }

    public int readWorkMode() {
        RequestNckItem item = new RequestNckItem(ENckArea.B_MODE_GROUP, 1, 3, 1, ENckModule.S, 1);
        DataItem dataItem = this.readS7NckData(item);
        return ByteReadBuff.newInstance(dataItem.getData(), true).getUInt16();
    }

    public int readStatus() {
        RequestNckItem item = new RequestNckItem(ENckArea.C_CHANNEL, 1, 11, 1, ENckModule.S, 1);
        DataItem dataItem = this.readS7NckData(item);
        return ByteReadBuff.newInstance(dataItem.getData(), true).getUInt16();
    }

    public double readRunTime() {
        RequestNckItem item = new RequestNckItem(ENckArea.C_CHANNEL, 1, 297, 1, ENckModule.S, 1);
        DataItem dataItem = this.readS7NckData(item);
        return ByteReadBuff.newInstance(dataItem.getData(), true).getFloat64();
    }

    public double readRemainTime() {
        RequestNckItem item = new RequestNckItem(ENckArea.C_CHANNEL, 1, 298, 1, ENckModule.S, 1);
        DataItem dataItem = this.readS7NckData(item);
        return ByteReadBuff.newInstance(dataItem.getData(), true).getFloat64();
    }

    public String readProgramName() {
        RequestNckItem item = new RequestNckItem(ENckArea.C_CHANNEL, 1, 12, 1, ENckModule.SPARPP, 1);
        DataItem dataItem = this.readS7NckData(item);
        return ByteReadBuff.newInstance(dataItem.getData(), true).getString(dataItem.getCount()).trim();
    }

    public int readAlarmNumber() {
        RequestNckItem item = new RequestNckItem(ENckArea.N_NCK, 1, 7, 1, ENckModule.S, 1);
        DataItem dataItem = this.readS7NckData(item);
        return ByteReadBuff.newInstance(dataItem.getData(), true).getUInt16();
    }

    public long readAlarmInfo() {
        RequestNckItem item = new RequestNckItem(ENckArea.N_NCK, 1, 1, 1, ENckModule.SALA, 1);
        DataItem dataItem = this.readS7NckData(item);
        return ByteReadBuff.newInstance(dataItem.getData(), true).getUInt32();
    }
}

