/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.utils;

import com.github.xingshuangs.iot.exceptions.HexParseException;

public class HexUtil {
    private static final String REGEX = "^[a-f0-9A-F]+$";

    private HexUtil() {
    }

    public static byte[] toHexArray(String src) {
        if (src == null || src.length() == 0) {
            throw new HexParseException("\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3anull\u6216\u957f\u5ea6\u4e0d\u80fd\u4e3a0");
        }
        if ((src.length() & -src.length()) == 1) {
            throw new HexParseException("\u8f93\u5165\u7684\u5b57\u7b26\u4e32\u4e2a\u6570\u5fc5\u987b\u4e3a\u5076\u6570");
        }
        if (!src.matches(REGEX)) {
            throw new HexParseException("\u5b57\u7b26\u4e32\u5185\u5bb9\u5fc5\u987b\u662f[0-9|a-f|A-F]");
        }
        char[] chars = src.toCharArray();
        byte[] out = new byte[chars.length >> 1];
        for (int i = 0; i < chars.length; i += 2) {
            int high = Character.digit(chars[i], 16) << 4;
            int low = Character.digit(chars[i + 1], 16);
            out[i / 2] = (byte)((high | low) & 0xFF);
        }
        return out;
    }

    public static String toHexString(byte[] src) {
        return HexUtil.toHexString(src, " ", true);
    }

    public static String toHexString(byte[] src, String splitStr) {
        return HexUtil.toHexString(src, splitStr, true);
    }

    public static String toHexString(byte[] src, String splitStr, boolean upperCase) {
        if (src == null || src.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String format = upperCase ? "%02X" : "%02x";
        for (int i = 0; i < src.length; ++i) {
            sb.append(String.format(format, src[i]));
            if (i == src.length - 1) continue;
            sb.append(splitStr);
        }
        return sb.toString().trim();
    }
}

