/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.utils;

public class IntegerUtil {
    private IntegerUtil() {
    }

    public static byte[] toByteArray(int data, boolean littleEndian) {
        byte[] bytes = new byte[4];
        if (littleEndian) {
            bytes[0] = (byte)(data & 0xFF);
            bytes[1] = (byte)(data >> 8 & 0xFF);
            bytes[2] = (byte)(data >> 16 & 0xFF);
            bytes[3] = (byte)(data >> 24 & 0xFF);
        } else {
            bytes[0] = (byte)(data >> 24 & 0xFF);
            bytes[1] = (byte)(data >> 16 & 0xFF);
            bytes[2] = (byte)(data >> 8 & 0xFF);
            bytes[3] = (byte)(data & 0xFF);
        }
        return bytes;
    }

    public static byte[] toByteArray(int data) {
        return IntegerUtil.toByteArray(data, false);
    }

    public static byte[] toByteArray(long data) {
        return IntegerUtil.toByteArray((int)data, false);
    }

    public static byte[] toCustomByteArray(long data, int offset, int length) {
        if (offset + length > 4) {
            throw new IndexOutOfBoundsException("offset + length > 4");
        }
        byte[] bytes = IntegerUtil.toByteArray((int)data, false);
        byte[] res = new byte[length];
        System.arraycopy(bytes, offset, res, 0, length);
        return res;
    }

    public static int toInt32(byte[] data) {
        return IntegerUtil.toInt32(data, 0, false);
    }

    public static int toInt32(byte[] data, int offset) {
        return IntegerUtil.toInt32(data, offset, false);
    }

    public static int toInt32(byte[] data, int offset, boolean littleEndian) {
        if (data.length < 4) {
            throw new IndexOutOfBoundsException("data\u5c0f\u4e8e4\u4e2a\u5b57\u8282");
        }
        if (offset + 4 > data.length) {
            throw new IndexOutOfBoundsException("offset + 4 > \u5b57\u8282\u957f\u5ea6");
        }
        int b = littleEndian ? 3 : 0;
        int d = littleEndian ? 1 : -1;
        return (data[offset + b - d * 0] & 0xFF) << 24 | (data[offset + b - d * 1] & 0xFF) << 16 | (data[offset + b - d * 2] & 0xFF) << 8 | (data[offset + b - d * 3] & 0xFF) << 0;
    }

    public static int toInt32In3Bytes(byte[] data, int offset) {
        return IntegerUtil.toInt32In3Bytes(data, offset, false);
    }

    public static int toInt32In3Bytes(byte[] data, int offset, boolean littleEndian) {
        if (data.length < 3) {
            throw new IndexOutOfBoundsException("data\u5c0f\u4e8e3\u4e2a\u5b57\u8282");
        }
        if (offset + 3 > data.length) {
            throw new IndexOutOfBoundsException("offset + 3 > \u5b57\u8282\u957f\u5ea6");
        }
        int b = littleEndian ? 2 : 0;
        int d = littleEndian ? 1 : -1;
        return (data[offset + b - d * 0] & 0xFF) << 16 | (data[offset + b - d * 1] & 0xFF) << 8 | (data[offset + b - d * 2] & 0xFF) << 0;
    }

    public static long toUInt32(byte[] data) {
        return IntegerUtil.toUInt32(data, 0, false);
    }

    public static long toUInt32(byte[] data, int offset) {
        return IntegerUtil.toUInt32(data, offset, false);
    }

    public static long toUInt32(byte[] data, int offset, boolean littleEndian) {
        if (data.length < 4) {
            throw new IndexOutOfBoundsException("data\u5c0f\u4e8e4\u4e2a\u5b57\u8282");
        }
        if (offset + 4 > data.length) {
            throw new IndexOutOfBoundsException("offset + 4 > \u5b57\u8282\u957f\u5ea6");
        }
        int b = littleEndian ? 3 : 0;
        int d = littleEndian ? 1 : -1;
        return (long)((data[offset + b - d * 0] & 0xFF) << 24 | (data[offset + b - d * 1] & 0xFF) << 16 | (data[offset + b - d * 2] & 0xFF) << 8 | (data[offset + b - d * 3] & 0xFF) << 0) & 0xFFFFFFFFL;
    }
}

