/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.swagger2;

import cn.hutool.core.collection.CollUtil;
import com.github.zuihou.swagger2.ExtRelativePathProvider;
import com.github.zuihou.swagger2.Swagger2Configuration;
import com.github.zuihou.swagger2.SwaggerProperties;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.web.bind.annotation.RequestMethod;
import springfox.documentation.PathProvider;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.builders.ResponseMessageBuilder;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.OAuth;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.ResourceOwnerPasswordCredentialsGrant;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;

@Import(value={Swagger2Configuration.class})
@ConditionalOnProperty(prefix="zuihou.swagger", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={SwaggerProperties.class})
public class SwaggerAutoConfiguration
implements BeanFactoryAware {
    protected SwaggerProperties swaggerProperties;
    protected ServletContext servletContext;
    private BeanFactory beanFactory;

    public SwaggerAutoConfiguration(SwaggerProperties swaggerProperties, ServletContext servletContext) {
        this.swaggerProperties = swaggerProperties;
        this.servletContext = servletContext;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Bean
    @ConditionalOnMissingBean
    public List<Docket> createRestApi() {
        ConfigurableBeanFactory configurableBeanFactory = (ConfigurableBeanFactory)this.beanFactory;
        LinkedList<Docket> docketList = new LinkedList<Docket>();
        if (this.swaggerProperties.getDocket().isEmpty()) {
            Docket docket = this.createDocket(this.swaggerProperties);
            configurableBeanFactory.registerSingleton(this.swaggerProperties.getTitle(), (Object)docket);
            docketList.add(docket);
            return docketList;
        }
        for (String groupName : this.swaggerProperties.getDocket().keySet()) {
            SwaggerProperties.DocketInfo docketInfo = this.swaggerProperties.getDocket().get(groupName);
            ApiInfo apiInfo = new ApiInfoBuilder().title(docketInfo.getTitle().isEmpty() ? this.swaggerProperties.getTitle() : docketInfo.getTitle()).description(docketInfo.getDescription().isEmpty() ? this.swaggerProperties.getDescription() : docketInfo.getDescription()).version(docketInfo.getVersion().isEmpty() ? this.swaggerProperties.getVersion() : docketInfo.getVersion()).license(docketInfo.getLicense().isEmpty() ? this.swaggerProperties.getLicense() : docketInfo.getLicense()).licenseUrl(docketInfo.getLicenseUrl().isEmpty() ? this.swaggerProperties.getLicenseUrl() : docketInfo.getLicenseUrl()).contact(new Contact(docketInfo.getContact().getName().isEmpty() ? this.swaggerProperties.getContact().getName() : docketInfo.getContact().getName(), docketInfo.getContact().getUrl().isEmpty() ? this.swaggerProperties.getContact().getUrl() : docketInfo.getContact().getUrl(), docketInfo.getContact().getEmail().isEmpty() ? this.swaggerProperties.getContact().getEmail() : docketInfo.getContact().getEmail())).termsOfServiceUrl(docketInfo.getTermsOfServiceUrl().isEmpty() ? this.swaggerProperties.getTermsOfServiceUrl() : docketInfo.getTermsOfServiceUrl()).build();
            if (docketInfo.getIncludePath().isEmpty()) {
                docketInfo.getIncludePath().add("/**");
            }
            ArrayList<Predicate> includePath = new ArrayList<Predicate>(docketInfo.getIncludePath().size());
            for (String string : docketInfo.getIncludePath()) {
                includePath.add(PathSelectors.ant((String)string));
            }
            ArrayList<Predicate> excludePath = new ArrayList<Predicate>(docketInfo.getExcludePath().size());
            for (String path3 : docketInfo.getExcludePath()) {
                excludePath.add(PathSelectors.ant((String)path3));
            }
            List<Parameter> list = this.assemblyGlobalOperationParameters(this.swaggerProperties.getGlobalOperationParameters(), docketInfo.getGlobalOperationParameters());
            Docket docket = new Docket(DocumentationType.SWAGGER_2).host(this.swaggerProperties.getHost()).apiInfo(apiInfo).globalOperationParameters(list).groupName(docketInfo.getGroup()).select().apis(RequestHandlerSelectors.basePackage((String)docketInfo.getBasePackage())).paths(Predicates.and((Predicate)Predicates.not((Predicate)Predicates.or(excludePath)), (Predicate)Predicates.or(includePath))).build().securitySchemes(this.securitySchemes(this.swaggerProperties.getAuthorization(), docketInfo.getAuthorization(), this.swaggerProperties.getApiKeys(), docketInfo.getApiKeys())).securityContexts(this.securityContexts(this.swaggerProperties.getAuthorization(), docketInfo.getAuthorization())).globalResponseMessage(RequestMethod.GET, this.getResponseMessages()).globalResponseMessage(RequestMethod.POST, this.getResponseMessages()).globalResponseMessage(RequestMethod.PUT, this.getResponseMessages()).globalResponseMessage(RequestMethod.DELETE, this.getResponseMessages()).pathProvider((PathProvider)new ExtRelativePathProvider(this.servletContext, docketInfo.getBasePath().isEmpty() ? this.swaggerProperties.getBasePath() : docketInfo.getBasePath()));
            configurableBeanFactory.registerSingleton(groupName, (Object)docket);
            docketList.add(docket);
        }
        return docketList;
    }

    private Docket createDocket(SwaggerProperties swaggerProperties) {
        ApiInfo apiInfo = new ApiInfoBuilder().title(swaggerProperties.getTitle()).description(swaggerProperties.getDescription()).version(swaggerProperties.getVersion()).license(swaggerProperties.getLicense()).licenseUrl(swaggerProperties.getLicenseUrl()).contact(new Contact(swaggerProperties.getContact().getName(), swaggerProperties.getContact().getUrl(), swaggerProperties.getContact().getEmail())).termsOfServiceUrl(swaggerProperties.getTermsOfServiceUrl()).build();
        if (swaggerProperties.getIncludePath().isEmpty()) {
            swaggerProperties.getIncludePath().add("/**");
        }
        ArrayList<Predicate> basePath = new ArrayList<Predicate>();
        for (String path : swaggerProperties.getIncludePath()) {
            basePath.add(PathSelectors.ant((String)path));
        }
        ArrayList<Predicate> excludePath = new ArrayList<Predicate>();
        for (String path : swaggerProperties.getExcludePath()) {
            excludePath.add(PathSelectors.ant((String)path));
        }
        return new Docket(DocumentationType.SWAGGER_2).host(swaggerProperties.getHost()).apiInfo(apiInfo).groupName(swaggerProperties.getGroup()).globalOperationParameters(this.buildGlobalOperationParametersFromSwaggerProperties(swaggerProperties.getGlobalOperationParameters())).select().apis(RequestHandlerSelectors.basePackage((String)swaggerProperties.getBasePackage())).paths(Predicates.and((Predicate)Predicates.not((Predicate)Predicates.or(excludePath)), (Predicate)Predicates.or(basePath))).build().securitySchemes(this.securitySchemes(swaggerProperties.getAuthorization(), null, swaggerProperties.getApiKeys(), null)).securityContexts(this.securityContexts(swaggerProperties.getAuthorization(), null)).globalResponseMessage(RequestMethod.GET, this.getResponseMessages()).globalResponseMessage(RequestMethod.POST, this.getResponseMessages()).globalResponseMessage(RequestMethod.PUT, this.getResponseMessages()).globalResponseMessage(RequestMethod.DELETE, this.getResponseMessages()).pathProvider((PathProvider)new ExtRelativePathProvider(this.servletContext, swaggerProperties.getBasePath()));
    }

    private List<ResponseMessage> getResponseMessages() {
        List<ResponseMessage> collect = Arrays.asList(new ResponseMessageBuilder().code(0).message("\u6210\u529f").build(), new ResponseMessageBuilder().code(-1).message("\u7cfb\u7edf\u7e41\u5fd9").build(), new ResponseMessageBuilder().code(-2).message("\u670d\u52a1\u8d85\u65f6").build(), new ResponseMessageBuilder().code(40001).message("\u4f1a\u8bdd\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55").build(), new ResponseMessageBuilder().code(40003).message("\u7f3a\u5c11token\u53c2\u6570").build());
        return collect;
    }

    private List<SecurityReference> defaultAuth(SwaggerProperties.Authorization authorization) {
        ArrayList authorizationScopeList = new ArrayList();
        authorization.getAuthorizationScopeList().forEach(authorizationScope -> authorizationScopeList.add(new AuthorizationScope(authorizationScope.getScope(), authorizationScope.getDescription())));
        AuthorizationScope[] authorizationScopes = new AuthorizationScope[authorizationScopeList.size()];
        return Collections.singletonList(SecurityReference.builder().reference(authorization.getName()).scopes(authorizationScopeList.toArray(authorizationScopes)).build());
    }

    private List<SecurityContext> securityContexts(SwaggerProperties.Authorization globalAuthorization, SwaggerProperties.Authorization docketAuthorization) {
        SwaggerProperties.Authorization authorization = docketAuthorization == null ? globalAuthorization : docketAuthorization;
        return authorization == null ? Collections.emptyList() : Collections.singletonList(SecurityContext.builder().securityReferences(this.defaultAuth(authorization)).forPaths(PathSelectors.regex((String)authorization.getAuthRegex())).build());
    }

    private List<SecurityScheme> securitySchemes(SwaggerProperties.Authorization globalAuthorization, SwaggerProperties.Authorization docketAuthorization, List<SwaggerProperties.ApiKey> globalApiKeys, List<SwaggerProperties.ApiKey> docketApiKeys) {
        List<SwaggerProperties.ApiKey> apiKeys;
        SwaggerProperties.Authorization authorization;
        ArrayList<SecurityScheme> list = new ArrayList<SecurityScheme>();
        SwaggerProperties.Authorization authorization2 = authorization = docketAuthorization == null ? globalAuthorization : docketAuthorization;
        if (authorization != null) {
            ArrayList authorizationScopeList = new ArrayList();
            authorization.getAuthorizationScopeList().forEach(authorizationScope -> authorizationScopeList.add(new AuthorizationScope(authorizationScope.getScope(), authorizationScope.getDescription())));
            ArrayList grantTypes = new ArrayList();
            authorization.getTokenUrlList().forEach(tokenUrl -> grantTypes.add(new ResourceOwnerPasswordCredentialsGrant(tokenUrl)));
            OAuth oAuth = new OAuth(authorization.getName(), authorizationScopeList, grantTypes);
            list.add((SecurityScheme)oAuth);
        }
        List<SwaggerProperties.ApiKey> list2 = apiKeys = CollUtil.isEmpty(docketApiKeys) ? globalApiKeys : docketApiKeys;
        if (CollUtil.isNotEmpty(apiKeys)) {
            ArrayList<SwaggerProperties.ApiKey> allApiKeys = new ArrayList<SwaggerProperties.ApiKey>(apiKeys);
            if (globalApiKeys != null && apiKeys != globalApiKeys) {
                allApiKeys = new ArrayList<SwaggerProperties.ApiKey>(globalApiKeys);
                Set docketNames = allApiKeys.stream().map(SwaggerProperties.ApiKey::getKeyname).collect(Collectors.toSet());
                for (SwaggerProperties.ApiKey ak : docketApiKeys) {
                    if (docketNames.contains(ak.getKeyname())) continue;
                    allApiKeys.add(ak);
                }
            }
            List apiKeyList = allApiKeys.stream().map(item -> new ApiKey(item.getName(), item.getKeyname(), item.getPassAs())).collect(Collectors.toList());
            list.addAll(apiKeyList);
        }
        return list;
    }

    private List<Parameter> buildGlobalOperationParametersFromSwaggerProperties(List<SwaggerProperties.GlobalOperationParameter> globalOperationParameters) {
        ArrayList parameters = Lists.newArrayList();
        if (Objects.isNull(globalOperationParameters)) {
            return parameters;
        }
        for (SwaggerProperties.GlobalOperationParameter globalOperationParameter : globalOperationParameters) {
            parameters.add(new ParameterBuilder().name(globalOperationParameter.getName()).description(globalOperationParameter.getDescription()).defaultValue(globalOperationParameter.getDefaultValue()).required(globalOperationParameter.getRequired().booleanValue()).allowMultiple(globalOperationParameter.getAllowMultiple().booleanValue()).parameterType(globalOperationParameter.getParameterType()).modelRef((ModelReference)new ModelRef(globalOperationParameter.getModelRef())).hidden(globalOperationParameter.getHidden().booleanValue()).pattern(globalOperationParameter.getPattern()).collectionFormat(globalOperationParameter.getCollectionFormat()).allowEmptyValue(globalOperationParameter.getAllowEmptyValue()).order(globalOperationParameter.getOrder()).build());
        }
        return parameters;
    }

    private List<Parameter> assemblyGlobalOperationParameters(List<SwaggerProperties.GlobalOperationParameter> globalOperationParameters, List<SwaggerProperties.GlobalOperationParameter> docketOperationParameters) {
        if (Objects.isNull(docketOperationParameters) || docketOperationParameters.isEmpty()) {
            return this.buildGlobalOperationParametersFromSwaggerProperties(globalOperationParameters);
        }
        Set docketNames = docketOperationParameters.stream().map(SwaggerProperties.GlobalOperationParameter::getName).collect(Collectors.toSet());
        ArrayList resultOperationParameters = Lists.newArrayList();
        if (Objects.nonNull(globalOperationParameters)) {
            for (SwaggerProperties.GlobalOperationParameter parameter : globalOperationParameters) {
                if (docketNames.contains(parameter.getName())) continue;
                resultOperationParameters.add(parameter);
            }
        }
        resultOperationParameters.addAll(docketOperationParameters);
        return this.buildGlobalOperationParametersFromSwaggerProperties(resultOperationParameters);
    }
}

