/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.fsg.uid.impl;

import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.util.IdUtil;
import com.baidu.fsg.uid.UidGenerator;
import com.baidu.fsg.uid.exception.UidGenerateException;

public class HutoolUidGenerator
implements UidGenerator {
    private final Snowflake snowflake;

    public HutoolUidGenerator(long workerId, long datacenterId) {
        this.snowflake = IdUtil.getSnowflake((long)workerId, (long)datacenterId);
    }

    @Override
    public long getUID() throws UidGenerateException {
        return this.snowflake.nextId();
    }

    @Override
    public String parseUID(long uid) {
        long workerId = this.snowflake.getWorkerId(uid);
        long dataCenterId = this.snowflake.getDataCenterId(uid);
        long timestamp = this.snowflake.getGenerateDateTime(uid);
        return String.format("{\"UID\":\"%d\",\"timestamp\":\"%d\",\"workerId\":\"%d\",\"dataCenterId\":\"%d\"}", uid, timestamp, workerId, dataCenterId);
    }
}

