/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.parallel.list;

import com.gs.collections.api.annotation.Beta;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.impl.block.procedure.IfProcedure;
import com.gs.collections.impl.lazy.parallel.AbstractBatch;
import com.gs.collections.impl.lazy.parallel.list.CollectListBatch;
import com.gs.collections.impl.lazy.parallel.list.DistinctBatch;
import com.gs.collections.impl.lazy.parallel.list.ListBatch;
import com.gs.collections.impl.lazy.parallel.set.UnsortedSetBatch;
import com.gs.collections.impl.map.mutable.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public class SelectListBatch<T>
extends AbstractBatch<T>
implements ListBatch<T> {
    private final ListBatch<T> listBatch;
    private final Predicate<? super T> predicate;

    public SelectListBatch(ListBatch<T> listBatch, Predicate<? super T> predicate) {
        this.listBatch = listBatch;
        this.predicate = predicate;
    }

    @Override
    public void forEach(Procedure<? super T> procedure) {
        this.listBatch.forEach(new IfProcedure<T>(this.predicate, procedure));
    }

    @Override
    public ListBatch<T> select(Predicate<? super T> predicate) {
        return new SelectListBatch<T>(this, predicate);
    }

    @Override
    public <V> ListBatch<V> collect(Function<? super T, ? extends V> function) {
        return new CollectListBatch<T, V>(this, function);
    }

    @Override
    public UnsortedSetBatch<T> distinct(ConcurrentHashMap<T, Boolean> distinct) {
        return new DistinctBatch<T>(this, distinct);
    }
}

