/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.list.immutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.factory.list.primitive.ImmutableFloatListFactory;
import com.gs.collections.api.list.primitive.ImmutableFloatList;
import com.gs.collections.impl.list.immutable.primitive.ImmutableFloatArrayList;
import com.gs.collections.impl.list.immutable.primitive.ImmutableFloatEmptyList;
import com.gs.collections.impl.list.immutable.primitive.ImmutableFloatSingletonList;

public class ImmutableFloatListFactoryImpl
implements ImmutableFloatListFactory {
    public ImmutableFloatList of() {
        return this.with();
    }

    public ImmutableFloatList with() {
        return ImmutableFloatEmptyList.INSTANCE;
    }

    public ImmutableFloatList of(float one) {
        return this.with(one);
    }

    public ImmutableFloatList with(float one) {
        return new ImmutableFloatSingletonList(one);
    }

    public ImmutableFloatList of(float ... items) {
        return this.with(items);
    }

    public ImmutableFloatList with(float ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableFloatArrayList.newListWith(items);
    }

    public ImmutableFloatList ofAll(FloatIterable items) {
        return this.withAll(items);
    }

    public ImmutableFloatList withAll(FloatIterable items) {
        if (items instanceof ImmutableFloatList) {
            return (ImmutableFloatList)items;
        }
        return this.with(items.toArray());
    }
}

