/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiAsyncFunction;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.firestore.BulkCommitBatch;
import com.google.cloud.firestore.BulkWriterException;
import com.google.cloud.firestore.BulkWriterOperation;
import com.google.cloud.firestore.BulkWriterOptions;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.Precondition;
import com.google.cloud.firestore.RateLimiter;
import com.google.cloud.firestore.SetOptions;
import com.google.cloud.firestore.WriteResult;
import com.google.cloud.firestore.v1.FirestoreSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

@BetaApi
public final class BulkWriter
implements AutoCloseable {
    public static final int MAX_BATCH_SIZE = 20;
    public static final int MAX_RETRY_ATTEMPTS = 10;
    static final int DEFAULT_STARTING_MAXIMUM_OPS_PER_SECOND = 500;
    private static final double RATE_LIMITER_MULTIPLIER = 1.5;
    private static final int RATE_LIMITER_MULTIPLIER_MILLIS = 300000;
    private static final int DEFAULT_MAXIMUM_PENDING_OPERATIONS_COUNT = 500;
    static final double DEFAULT_JITTER_FACTOR = 0.3;
    private static final WriteResultCallback DEFAULT_SUCCESS_LISTENER = new WriteResultCallback(){

        @Override
        public void onResult(DocumentReference documentReference, WriteResult result) {
        }
    };
    private static final WriteErrorCallback DEFAULT_ERROR_LISTENER = new WriteErrorCallback(){

        @Override
        public boolean onError(BulkWriterException error) {
            if (error.getFailedAttempts() > 10) {
                return false;
            }
            Set codes = FirestoreSettings.newBuilder().batchWriteSettings().getRetryableCodes();
            for (StatusCode.Code code : codes) {
                if (!code.equals((Object)StatusCode.Code.valueOf((String)error.getStatus().getCode().name()))) continue;
                return true;
            }
            return false;
        }
    };
    private static final Logger logger = Logger.getLogger(BulkWriter.class.getName());
    private final FirestoreImpl firestore;
    private final ScheduledExecutorService bulkWriterExecutor;
    private int maxBatchSize = 20;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final RateLimiter rateLimiter;
    @GuardedBy(value="lock")
    private int pendingOpsCount = 0;
    @GuardedBy(value="lock")
    private final List<Runnable> bufferedOperations = new ArrayList<Runnable>();
    private int maxPendingOpCount = 500;
    @GuardedBy(value="lock")
    private BulkCommitBatch bulkCommitBatch;
    @GuardedBy(value="lock")
    private ApiFuture<Void> lastOperation = ApiFutures.immediateFuture(null);
    @GuardedBy(value="lock")
    private boolean closed = false;
    @GuardedBy(value="lock")
    private WriteResultCallback successListener = DEFAULT_SUCCESS_LISTENER;
    @GuardedBy(value="lock")
    private WriteErrorCallback errorListener = DEFAULT_ERROR_LISTENER;
    @GuardedBy(value="lock")
    private Executor successExecutor;
    @GuardedBy(value="lock")
    private Executor errorExecutor;
    @GuardedBy(value="lock")
    private boolean writesEnqueued = false;

    BulkWriter(FirestoreImpl firestore, BulkWriterOptions options) {
        this.firestore = firestore;
        this.bulkWriterExecutor = options.getExecutor() != null ? options.getExecutor() : Executors.newSingleThreadScheduledExecutor();
        this.successExecutor = MoreExecutors.directExecutor();
        this.errorExecutor = MoreExecutors.directExecutor();
        this.bulkCommitBatch = new BulkCommitBatch(firestore, this.bulkWriterExecutor);
        if (!options.getThrottlingEnabled()) {
            this.rateLimiter = new RateLimiter(Integer.MAX_VALUE, 2.147483647E9, Integer.MAX_VALUE, Integer.MAX_VALUE);
        } else {
            double startingRate = 500.0;
            double maxRate = Double.POSITIVE_INFINITY;
            if (options.getInitialOpsPerSecond() != null) {
                startingRate = options.getInitialOpsPerSecond();
            }
            if (options.getMaxOpsPerSecond() != null) {
                maxRate = options.getMaxOpsPerSecond();
            }
            if (maxRate < startingRate) {
                startingRate = maxRate;
            }
            if (startingRate < (double)this.maxBatchSize) {
                this.maxBatchSize = (int)startingRate;
            }
            this.rateLimiter = new RateLimiter((int)startingRate, 1.5, 300000, (int)maxRate);
        }
    }

    @Nonnull
    public ApiFuture<WriteResult> create(final @Nonnull DocumentReference documentReference, final @Nonnull Map<String, Object> fields) {
        return this.executeWrite(documentReference, OperationType.CREATE, new ApiFunction<BulkCommitBatch, ApiFuture<WriteResult>>(){

            public ApiFuture<WriteResult> apply(BulkCommitBatch batch) {
                return (ApiFuture)batch.create(documentReference, fields);
            }
        });
    }

    @Nonnull
    public ApiFuture<WriteResult> create(final @Nonnull DocumentReference documentReference, final @Nonnull Object pojo) {
        return this.executeWrite(documentReference, OperationType.CREATE, new ApiFunction<BulkCommitBatch, ApiFuture<WriteResult>>(){

            public ApiFuture<WriteResult> apply(BulkCommitBatch batch) {
                return (ApiFuture)batch.create(documentReference, pojo);
            }
        });
    }

    @Nonnull
    public ApiFuture<WriteResult> delete(final @Nonnull DocumentReference documentReference) {
        return this.executeWrite(documentReference, OperationType.DELETE, new ApiFunction<BulkCommitBatch, ApiFuture<WriteResult>>(){

            public ApiFuture<WriteResult> apply(BulkCommitBatch batch) {
                return (ApiFuture)batch.delete(documentReference);
            }
        });
    }

    @Nonnull
    public ApiFuture<WriteResult> delete(final @Nonnull DocumentReference documentReference, final @Nonnull Precondition precondition) {
        return this.executeWrite(documentReference, OperationType.DELETE, new ApiFunction<BulkCommitBatch, ApiFuture<WriteResult>>(){

            public ApiFuture<WriteResult> apply(BulkCommitBatch batch) {
                return (ApiFuture)batch.delete(documentReference, precondition);
            }
        });
    }

    @Nonnull
    public ApiFuture<WriteResult> set(final @Nonnull DocumentReference documentReference, final @Nonnull Map<String, Object> fields) {
        return this.executeWrite(documentReference, OperationType.SET, new ApiFunction<BulkCommitBatch, ApiFuture<WriteResult>>(){

            public ApiFuture<WriteResult> apply(BulkCommitBatch batch) {
                return (ApiFuture)batch.set(documentReference, fields);
            }
        });
    }

    @Nonnull
    public ApiFuture<WriteResult> set(final @Nonnull DocumentReference documentReference, final @Nonnull Map<String, Object> fields, final @Nonnull SetOptions options) {
        return this.executeWrite(documentReference, OperationType.SET, new ApiFunction<BulkCommitBatch, ApiFuture<WriteResult>>(){

            public ApiFuture<WriteResult> apply(BulkCommitBatch batch) {
                return (ApiFuture)batch.set(documentReference, fields, options);
            }
        });
    }

    @Nonnull
    public ApiFuture<WriteResult> set(final @Nonnull DocumentReference documentReference, final @Nonnull Object pojo, final @Nonnull SetOptions options) {
        return this.executeWrite(documentReference, OperationType.SET, new ApiFunction<BulkCommitBatch, ApiFuture<WriteResult>>(){

            public ApiFuture<WriteResult> apply(BulkCommitBatch batch) {
                return (ApiFuture)batch.set(documentReference, pojo, options);
            }
        });
    }

    @Nonnull
    public ApiFuture<WriteResult> set(final @Nonnull DocumentReference documentReference, final @Nonnull Object pojo) {
        return this.executeWrite(documentReference, OperationType.SET, new ApiFunction<BulkCommitBatch, ApiFuture<WriteResult>>(){

            public ApiFuture<WriteResult> apply(BulkCommitBatch batch) {
                return (ApiFuture)batch.set(documentReference, pojo);
            }
        });
    }

    @Nonnull
    public ApiFuture<WriteResult> update(final @Nonnull DocumentReference documentReference, final @Nonnull Map<String, Object> fields) {
        return this.executeWrite(documentReference, OperationType.UPDATE, new ApiFunction<BulkCommitBatch, ApiFuture<WriteResult>>(){

            public ApiFuture<WriteResult> apply(BulkCommitBatch batch) {
                return (ApiFuture)batch.update(documentReference, fields);
            }
        });
    }

    @Nonnull
    public ApiFuture<WriteResult> update(final @Nonnull DocumentReference documentReference, final @Nonnull Map<String, Object> fields, final @Nonnull Precondition precondition) {
        return this.executeWrite(documentReference, OperationType.UPDATE, new ApiFunction<BulkCommitBatch, ApiFuture<WriteResult>>(){

            public ApiFuture<WriteResult> apply(BulkCommitBatch batch) {
                return (ApiFuture)batch.update(documentReference, fields, precondition);
            }
        });
    }

    @Nonnull
    public ApiFuture<WriteResult> update(final @Nonnull DocumentReference documentReference, final @Nonnull String field, final @Nullable Object value, final Object ... moreFieldsAndValues) {
        return this.executeWrite(documentReference, OperationType.UPDATE, new ApiFunction<BulkCommitBatch, ApiFuture<WriteResult>>(){

            public ApiFuture<WriteResult> apply(BulkCommitBatch batch) {
                return (ApiFuture)batch.update(documentReference, field, value, moreFieldsAndValues);
            }
        });
    }

    @Nonnull
    public ApiFuture<WriteResult> update(final @Nonnull DocumentReference documentReference, final @Nonnull FieldPath fieldPath, final @Nullable Object value, final Object ... moreFieldsAndValues) {
        return this.executeWrite(documentReference, OperationType.UPDATE, new ApiFunction<BulkCommitBatch, ApiFuture<WriteResult>>(){

            public ApiFuture<WriteResult> apply(BulkCommitBatch batch) {
                return (ApiFuture)batch.update(documentReference, fieldPath, value, moreFieldsAndValues);
            }
        });
    }

    @Nonnull
    public ApiFuture<WriteResult> update(final @Nonnull DocumentReference documentReference, final @Nonnull Precondition precondition, final @Nonnull String field, final @Nullable Object value, final Object ... moreFieldsAndValues) {
        return this.executeWrite(documentReference, OperationType.UPDATE, new ApiFunction<BulkCommitBatch, ApiFuture<WriteResult>>(){

            public ApiFuture<WriteResult> apply(BulkCommitBatch batch) {
                return (ApiFuture)batch.update(documentReference, precondition, field, value, moreFieldsAndValues);
            }
        });
    }

    @Nonnull
    public ApiFuture<WriteResult> update(final @Nonnull DocumentReference documentReference, final @Nonnull Precondition precondition, final @Nonnull FieldPath fieldPath, final @Nullable Object value, final Object ... moreFieldsAndValues) {
        return this.executeWrite(documentReference, OperationType.UPDATE, new ApiFunction<BulkCommitBatch, ApiFuture<WriteResult>>(){

            public ApiFuture<WriteResult> apply(BulkCommitBatch batch) {
                return (ApiFuture)batch.update(documentReference, precondition, fieldPath, value, moreFieldsAndValues);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApiFuture<WriteResult> executeWrite(final DocumentReference documentReference, OperationType operationType, final ApiFunction<BulkCommitBatch, ApiFuture<WriteResult>> enqueueOperationOnBatchCallback) {
        final BulkWriterOperation operation = new BulkWriterOperation(documentReference, operationType, new ApiFunction<BulkWriterOperation, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void apply(BulkWriterOperation operation) {
                Object object = BulkWriter.this.lock;
                synchronized (object) {
                    BulkWriter.this.sendOperationLocked((ApiFunction<BulkCommitBatch, ApiFuture<WriteResult>>)enqueueOperationOnBatchCallback, operation);
                }
                return null;
            }
        }, new ApiFunction<WriteResult, ApiFuture<Void>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ApiFuture<Void> apply(WriteResult writeResult) {
                Object object = BulkWriter.this.lock;
                synchronized (object) {
                    return BulkWriter.this.invokeUserSuccessCallbackLocked(documentReference, writeResult);
                }
            }
        }, new ApiFunction<BulkWriterException, ApiFuture<Boolean>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ApiFuture<Boolean> apply(BulkWriterException e) {
                Object object = BulkWriter.this.lock;
                synchronized (object) {
                    return BulkWriter.this.invokeUserErrorCallbackLocked(e);
                }
            }
        });
        Object object = this.lock;
        synchronized (object) {
            this.verifyNotClosedLocked();
            this.writesEnqueued = true;
            this.lastOperation = ApiFutures.transformAsync(this.lastOperation, (ApiAsyncFunction)new ApiAsyncFunction<Void, Void>(){

                public ApiFuture<Void> apply(Void aVoid) {
                    return BulkWriter.silenceFuture(operation.getFuture());
                }
            }, (Executor)MoreExecutors.directExecutor());
            if (this.pendingOpsCount < this.maxPendingOpCount) {
                ++this.pendingOpsCount;
                this.sendOperationLocked(enqueueOperationOnBatchCallback, operation);
            } else {
                this.bufferedOperations.add(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = BulkWriter.this.lock;
                        synchronized (object) {
                            BulkWriter.this.pendingOpsCount++;
                            BulkWriter.this.sendOperationLocked((ApiFunction<BulkCommitBatch, ApiFuture<WriteResult>>)enqueueOperationOnBatchCallback, operation);
                        }
                    }
                });
            }
        }
        ApiFuture processedOperationFuture = ApiFutures.transformAsync(operation.getFuture(), (ApiAsyncFunction)new ApiAsyncFunction<WriteResult, WriteResult>(){

            public ApiFuture<WriteResult> apply(WriteResult result) throws Exception {
                BulkWriter.this.pendingOpsCount--;
                BulkWriter.this.processBufferedOperations();
                return ApiFutures.immediateFuture((Object)result);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return ApiFutures.catchingAsync((ApiFuture)processedOperationFuture, ApiException.class, (ApiAsyncFunction)new ApiAsyncFunction<ApiException, WriteResult>(){

            public ApiFuture<WriteResult> apply(ApiException e) throws Exception {
                BulkWriter.this.pendingOpsCount--;
                BulkWriter.this.processBufferedOperations();
                throw e;
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private void processBufferedOperations() {
        if (this.pendingOpsCount < this.maxPendingOpCount && this.bufferedOperations.size() > 0) {
            Runnable nextOp = this.bufferedOperations.remove(0);
            nextOp.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ApiFuture<Void> flush() {
        Object object = this.lock;
        synchronized (object) {
            return this.flushLocked();
        }
    }

    private ApiFuture<Void> flushLocked() {
        this.verifyNotClosedLocked();
        this.scheduleCurrentBatchLocked(true);
        return this.lastOperation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws InterruptedException, ExecutionException {
        ApiFuture<Void> flushFuture;
        Object object = this.lock;
        synchronized (object) {
            flushFuture = this.flushLocked();
            this.closed = true;
        }
        flushFuture.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void verifyNotClosed() {
        Object object = this.lock;
        synchronized (object) {
            this.verifyNotClosedLocked();
        }
    }

    void verifyNotClosedLocked() {
        if (this.closed) {
            throw new IllegalStateException("BulkWriter has already been closed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWriteResultListener(WriteResultCallback writeResultCallback) {
        Object object = this.lock;
        synchronized (object) {
            this.successListener = writeResultCallback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWriteResultListener(@Nonnull Executor executor, WriteResultCallback writeResultCallback) {
        Object object = this.lock;
        synchronized (object) {
            if (this.writesEnqueued) {
                throw new IllegalStateException("The executor cannot be changed once writes have been enqueued.");
            }
            this.successListener = writeResultCallback;
            this.successExecutor = executor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWriteErrorListener(WriteErrorCallback onError) {
        Object object = this.lock;
        synchronized (object) {
            this.errorListener = onError;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWriteErrorListener(@Nonnull Executor executor, WriteErrorCallback onError) {
        Object object = this.lock;
        synchronized (object) {
            if (this.writesEnqueued) {
                throw new IllegalStateException("The executor cannot be changed once writes have been enqueued.");
            }
            this.errorListener = onError;
            this.errorExecutor = executor;
        }
    }

    private void scheduleCurrentBatchLocked(final boolean flush) {
        if (this.bulkCommitBatch.getMutationsSize() == 0) {
            return;
        }
        final BulkCommitBatch pendingBatch = this.bulkCommitBatch;
        this.bulkCommitBatch = new BulkCommitBatch(this.firestore, this.bulkWriterExecutor);
        int highestBackoffDuration = 0;
        for (BulkWriterOperation op : pendingBatch.pendingOperations) {
            if (op.getBackoffDuration() <= highestBackoffDuration) continue;
            highestBackoffDuration = op.getBackoffDuration();
        }
        int backoffMsWithJitter = this.applyJitter(highestBackoffDuration);
        this.bulkWriterExecutor.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = BulkWriter.this.lock;
                synchronized (object) {
                    BulkWriter.this.sendBatchLocked(pendingBatch, flush);
                }
            }
        }, (long)backoffMsWithJitter, TimeUnit.MILLISECONDS);
    }

    private void sendBatchLocked(final BulkCommitBatch batch, final boolean flush) {
        boolean underRateLimit = this.rateLimiter.tryMakeRequest(batch.getMutationsSize());
        if (underRateLimit) {
            batch.bulkCommit().addListener(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (flush) {
                        Object object = BulkWriter.this.lock;
                        synchronized (object) {
                            BulkWriter.this.scheduleCurrentBatchLocked(true);
                        }
                    }
                }
            }, (Executor)this.bulkWriterExecutor);
        } else {
            long delayMs = this.rateLimiter.getNextRequestDelayMs(batch.getMutationsSize());
            logger.log(Level.FINE, String.format("Backing off for %d seconds", delayMs / 1000L));
            this.bulkWriterExecutor.schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = BulkWriter.this.lock;
                    synchronized (object) {
                        BulkWriter.this.sendBatchLocked(batch, flush);
                    }
                }
            }, delayMs, TimeUnit.MILLISECONDS);
        }
    }

    @VisibleForTesting
    void setMaxBatchSize(int size) {
        this.maxBatchSize = size;
    }

    @VisibleForTesting
    RateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    @VisibleForTesting
    int getBufferedOperationsCount() {
        return this.bufferedOperations.size();
    }

    @VisibleForTesting
    void setMaxPendingOpCount(int newMax) {
        this.maxPendingOpCount = newMax;
    }

    private void sendOperationLocked(ApiFunction<BulkCommitBatch, ApiFuture<WriteResult>> enqueueOperationOnBatchCallback, BulkWriterOperation op) {
        if (this.bulkCommitBatch.has(op.getDocumentReference())) {
            this.scheduleCurrentBatchLocked(false);
        }
        this.bulkCommitBatch.enqueueOperation(op);
        enqueueOperationOnBatchCallback.apply((Object)this.bulkCommitBatch);
        if (this.bulkCommitBatch.getMutationsSize() == this.maxBatchSize) {
            this.scheduleCurrentBatchLocked(false);
        }
    }

    private SettableApiFuture<Boolean> invokeUserErrorCallbackLocked(final BulkWriterException error) {
        final SettableApiFuture callbackResult = SettableApiFuture.create();
        final WriteErrorCallback listener = this.errorListener;
        this.errorExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    boolean shouldRetry = listener.onError(error);
                    callbackResult.set((Object)shouldRetry);
                }
                catch (Exception e) {
                    callbackResult.setException((Throwable)e);
                }
            }
        });
        return callbackResult;
    }

    private ApiFuture<Void> invokeUserSuccessCallbackLocked(final DocumentReference documentReference, final WriteResult result) {
        final SettableApiFuture callbackResult = SettableApiFuture.create();
        final WriteResultCallback listener = this.successListener;
        this.successExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    listener.onResult(documentReference, result);
                    callbackResult.set(null);
                }
                catch (Exception e) {
                    callbackResult.setException((Throwable)e);
                }
            }
        });
        return callbackResult;
    }

    static <T> SettableApiFuture<Void> silenceFuture(ApiFuture<T> future) {
        final SettableApiFuture flushCallback = SettableApiFuture.create();
        ApiFutures.addCallback(future, (ApiFutureCallback)new ApiFutureCallback<T>(){

            public void onFailure(Throwable throwable) {
                flushCallback.set(null);
            }

            public void onSuccess(T writeResult) {
                flushCallback.set(null);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return flushCallback;
    }

    private int applyJitter(int backoffMs) {
        if (backoffMs == 0) {
            return 0;
        }
        double jitter = 0.3 * (Math.random() * 2.0 - 1.0);
        return (int)Math.min(60000.0, (double)backoffMs + jitter * (double)backoffMs);
    }

    static enum OperationType {
        CREATE,
        SET,
        UPDATE,
        DELETE;

    }

    public static interface WriteErrorCallback {
        public boolean onError(BulkWriterException var1);
    }

    public static interface WriteResultCallback {
        public void onResult(DocumentReference var1, WriteResult var2);
    }
}

