/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.PreparedLayer;
import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.cache.CacheCorruptedException;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.docker.DockerClient;
import com.google.cloud.tools.jib.event.progress.ThrottledAccumulatingConsumer;
import com.google.cloud.tools.jib.hash.Digests;
import com.google.cloud.tools.jib.http.NotifyingOutputStream;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.LayerCountMismatchException;
import com.google.cloud.tools.jib.image.json.BadContainerConfigurationFormatException;
import com.google.cloud.tools.jib.image.json.ContainerConfigurationTemplate;
import com.google.cloud.tools.jib.image.json.JsonToImageTranslator;
import com.google.cloud.tools.jib.image.json.V22ManifestTemplate;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.zip.GZIPOutputStream;

public class LocalBaseImageSteps {
    @VisibleForTesting
    static boolean isGzipped(Path path) throws IOException {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            inputStream.mark(2);
            int magic = inputStream.read() & 0xFF | inputStream.read() << 8 & 0xFF00;
            boolean bl = magic == 35615;
            return bl;
        }
    }

    static Callable<LocalImage> retrieveDockerDaemonImageStep(ExecutorService executorService, BuildConfiguration buildConfiguration, ProgressEventDispatcher.Factory progressEventDispatcherFactory, DockerClient dockerClient) {
        return () -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        };
    }

    static Callable<LocalImage> retrieveTarImageStep(ExecutorService executorService, BuildConfiguration buildConfiguration, ProgressEventDispatcher.Factory progressEventDispatcherFactory, Path tarPath) {
        return () -> LocalBaseImageSteps.cacheDockerImageTar(buildConfiguration, executorService, tarPath, progressEventDispatcherFactory);
    }

    @VisibleForTesting
    static Optional<LocalImage> getCachedDockerImage(Cache cache, DockerClient.DockerImageDetails dockerImageDetails) throws DigestException, IOException, CacheCorruptedException, LayerCountMismatchException, BadContainerConfigurationFormatException {
        V22ManifestTemplate v22Manifest = new V22ManifestTemplate();
        ArrayList<PreparedLayer> cachedLayers = new ArrayList<PreparedLayer>();
        Optional<ContainerConfigurationTemplate> cachedConfig = cache.retrieveLocalConfig(dockerImageDetails.getImageId());
        if (!cachedConfig.isPresent()) {
            return Optional.empty();
        }
        for (DescriptorDigest diffId : dockerImageDetails.getDiffIds()) {
            Optional<CachedLayer> cachedLayer = cache.retrieveTarLayer(diffId);
            if (!cachedLayer.isPresent()) {
                return Optional.empty();
            }
            CachedLayer layer = cachedLayer.get();
            cachedLayers.add(new PreparedLayer.Builder(layer).build());
            v22Manifest.addLayer(layer.getSize(), layer.getDigest());
        }
        BlobDescriptor configDescriptor = Digests.computeDigest(cachedConfig.get());
        v22Manifest.setContainerConfiguration(configDescriptor.getSize(), configDescriptor.getDigest());
        Image image = JsonToImageTranslator.toImage(v22Manifest, cachedConfig.get());
        return Optional.of(new LocalImage(image, cachedLayers));
    }

    /*
     * Exception decompiling
     */
    @VisibleForTesting
    static LocalImage cacheDockerImageTar(BuildConfiguration buildConfiguration, ExecutorService executorService, Path tarPath, ProgressEventDispatcher.Factory progressEventDispatcherFactory) throws IOException, LayerCountMismatchException, BadContainerConfigurationFormatException, ExecutionException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static CachedLayer compressAndCacheTarLayer(Cache cache, DescriptorDigest diffId, Path layerFile, boolean layersAreCompressed, ProgressEventDispatcher.Factory progressEventDispatcherFactory) throws IOException, CacheCorruptedException {
        Throwable throwable = null;
        try (ProgressEventDispatcher childDispatcher = progressEventDispatcherFactory.create("compressing layer " + diffId, Files.size(layerFile));){
            CachedLayer cachedLayer;
            Throwable throwable2;
            ThrottledAccumulatingConsumer throttledProgressReporter;
            block16: {
                block15: {
                    throttledProgressReporter = new ThrottledAccumulatingConsumer(childDispatcher::dispatchProgress);
                    throwable2 = null;
                    Optional<CachedLayer> optionalLayer = cache.retrieveTarLayer(diffId);
                    if (!optionalLayer.isPresent()) break block15;
                    CachedLayer cachedLayer2 = optionalLayer.get();
                    LocalBaseImageSteps.$closeResource(throwable2, throttledProgressReporter);
                    return cachedLayer2;
                }
                if (!layersAreCompressed) break block16;
                CachedLayer cachedLayer3 = cache.writeTarLayer(diffId, Blobs.from(layerFile));
                LocalBaseImageSteps.$closeResource(throwable2, throttledProgressReporter);
                return cachedLayer3;
            }
            try {
                Blob compressedBlob = Blobs.from(outputStream -> {
                    GZIPOutputStream compressorStream = new GZIPOutputStream(outputStream);
                    Throwable throwable = null;
                    try {
                        NotifyingOutputStream notifyingOutputStream = new NotifyingOutputStream(compressorStream, throttledProgressReporter);
                        Throwable throwable2 = null;
                        try {
                            Blobs.from(layerFile).writeTo(notifyingOutputStream);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            LocalBaseImageSteps.$closeResource(throwable2, notifyingOutputStream);
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        LocalBaseImageSteps.$closeResource(throwable, compressorStream);
                    }
                });
                cachedLayer = cache.writeTarLayer(diffId, compressedBlob);
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        LocalBaseImageSteps.$closeResource(throwable2, throttledProgressReporter);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            LocalBaseImageSteps.$closeResource(throwable2, throttledProgressReporter);
            return cachedLayer;
        }
    }

    private static /* synthetic */ CachedLayer lambda$cacheDockerImageTar$2(BuildConfiguration buildConfiguration, DescriptorDigest diffId, Path layerFile, boolean layersAreCompressed, ProgressEventDispatcher.Factory layerProgressDispatcherFactory) throws Exception {
        return LocalBaseImageSteps.compressAndCacheTarLayer(buildConfiguration.getBaseImageLayersCache(), diffId, layerFile, layersAreCompressed, layerProgressDispatcherFactory);
    }

    static class LocalImage {
        final Image baseImage;
        final List<PreparedLayer> layers;

        LocalImage(Image baseImage, List<PreparedLayer> layers) {
            this.baseImage = baseImage;
            this.layers = layers;
        }
    }
}

