/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.api.Credential;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.AuthenticatePushStep;
import com.google.cloud.tools.jib.builder.steps.BuildAndCacheApplicationLayerStep;
import com.google.cloud.tools.jib.builder.steps.BuildImageStep;
import com.google.cloud.tools.jib.builder.steps.BuildResult;
import com.google.cloud.tools.jib.builder.steps.LoadDockerStep;
import com.google.cloud.tools.jib.builder.steps.LocalBaseImageSteps;
import com.google.cloud.tools.jib.builder.steps.ObtainBaseImageLayerStep;
import com.google.cloud.tools.jib.builder.steps.PreparedLayer;
import com.google.cloud.tools.jib.builder.steps.PullBaseImageStep;
import com.google.cloud.tools.jib.builder.steps.PushContainerConfigurationStep;
import com.google.cloud.tools.jib.builder.steps.PushImageStep;
import com.google.cloud.tools.jib.builder.steps.PushLayerStep;
import com.google.cloud.tools.jib.builder.steps.RetrieveRegistryCredentialsStep;
import com.google.cloud.tools.jib.builder.steps.WriteTarFileStep;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.configuration.ImageConfiguration;
import com.google.cloud.tools.jib.docker.DockerClient;
import com.google.cloud.tools.jib.filesystem.TempDirectoryProvider;
import com.google.cloud.tools.jib.global.JibSystemProperties;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.image.Image;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class StepsRunner {
    private final StepResults results = new StepResults();
    private final ExecutorService executorService;
    private final BuildConfiguration buildConfiguration;
    private final TempDirectoryProvider tempDirectoryProvider = new TempDirectoryProvider();
    private final List<Runnable> stepsToRun = new ArrayList<Runnable>();
    @Nullable
    private String rootProgressDescription;
    @Nullable
    private ProgressEventDispatcher rootProgressDispatcher;

    public static StepsRunner begin(BuildConfiguration buildConfiguration) {
        Object executorService = JibSystemProperties.serializeExecution() ? MoreExecutors.newDirectExecutorService() : buildConfiguration.getExecutorService();
        return new StepsRunner(MoreExecutors.listeningDecorator((ExecutorService)executorService), buildConfiguration);
    }

    private static <E> List<E> realizeFutures(List<Future<E>> futures) throws InterruptedException, ExecutionException {
        ArrayList<E> values = new ArrayList<E>();
        for (Future<E> future : futures) {
            values.add(future.get());
        }
        return values;
    }

    private StepsRunner(ListeningExecutorService executorService, BuildConfiguration buildConfiguration) {
        this.executorService = executorService;
        this.buildConfiguration = buildConfiguration;
    }

    public StepsRunner dockerLoadSteps(DockerClient dockerClient) {
        this.rootProgressDescription = "building image to Docker daemon";
        this.addRetrievalSteps(true);
        this.stepsToRun.add(this::buildAndCacheApplicationLayers);
        this.stepsToRun.add(this::buildImage);
        this.stepsToRun.add(() -> this.loadDocker(dockerClient));
        return this;
    }

    public StepsRunner tarBuildSteps(Path outputPath) {
        this.rootProgressDescription = "building image to tar file";
        this.addRetrievalSteps(true);
        this.stepsToRun.add(this::buildAndCacheApplicationLayers);
        this.stepsToRun.add(this::buildImage);
        this.stepsToRun.add(() -> this.writeTarFile(outputPath));
        return this;
    }

    public StepsRunner registryPushSteps() {
        this.rootProgressDescription = "building image to registry";
        boolean layersRequiredLocally = this.buildConfiguration.getAlwaysCacheBaseImage();
        this.stepsToRun.add(this::retrieveTargetRegistryCredentials);
        this.stepsToRun.add(this::authenticatePush);
        this.addRetrievalSteps(layersRequiredLocally);
        this.stepsToRun.add(this::buildAndCacheApplicationLayers);
        this.stepsToRun.add(this::buildImage);
        this.stepsToRun.add(this::pushBaseImageLayers);
        this.stepsToRun.add(this::pushApplicationLayers);
        this.stepsToRun.add(this::pushContainerConfiguration);
        this.stepsToRun.add(this::pushImages);
        return this;
    }

    /*
     * Exception decompiling
     */
    public BuildResult run() throws ExecutionException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addRetrievalSteps(boolean layersRequiredLocally) {
        ImageConfiguration baseImageConfiguration = this.buildConfiguration.getBaseImageConfiguration();
        if (baseImageConfiguration.getTarPath().isPresent()) {
            this.stepsToRun.add(this::extractTar);
        } else if (baseImageConfiguration.getDockerClient().isPresent()) {
            this.stepsToRun.add(this::saveDocker);
        } else {
            this.stepsToRun.add(this::pullBaseImage);
            this.stepsToRun.add(() -> this.obtainBaseImageLayers(layersRequiredLocally));
        }
    }

    private void retrieveTargetRegistryCredentials() {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.targetRegistryCredentials = this.executorService.submit(RetrieveRegistryCredentialsStep.forTargetImage(this.buildConfiguration, childProgressDispatcherFactory));
    }

    private void authenticatePush() {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.pushAuthorization = this.executorService.submit(() -> new AuthenticatePushStep(this.buildConfiguration, childProgressDispatcherFactory, ((Optional)this.results.targetRegistryCredentials.get()).orElse(null)).call());
    }

    private void saveDocker() {
        Optional<DockerClient> dockerClient = this.buildConfiguration.getBaseImageConfiguration().getDockerClient();
        Preconditions.checkArgument((boolean)dockerClient.isPresent());
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.assignLocalImageResult(this.executorService.submit(LocalBaseImageSteps.retrieveDockerDaemonImageStep(this.executorService, this.buildConfiguration, childProgressDispatcherFactory, dockerClient.get())));
    }

    private void extractTar() {
        Optional<Path> tarPath = this.buildConfiguration.getBaseImageConfiguration().getTarPath();
        Preconditions.checkArgument((boolean)tarPath.isPresent());
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.assignLocalImageResult(this.executorService.submit(LocalBaseImageSteps.retrieveTarImageStep(this.executorService, this.buildConfiguration, childProgressDispatcherFactory, tarPath.get())));
    }

    private void assignLocalImageResult(Future<LocalBaseImageSteps.LocalImage> localImageFuture) {
        this.results.baseImageAndAuth = this.executorService.submit(() -> new PullBaseImageStep.ImageAndAuthorization(((LocalBaseImageSteps.LocalImage)localImageFuture.get()).baseImage, null));
        this.results.baseImageLayers = this.executorService.submit(() -> ((LocalBaseImageSteps.LocalImage)localImageFuture.get()).layers.stream().map(Futures::immediateFuture).collect(Collectors.toList()));
    }

    private void pullBaseImage() {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.baseImageAndAuth = this.executorService.submit(new PullBaseImageStep(this.buildConfiguration, childProgressDispatcherFactory));
    }

    private void obtainBaseImageLayers(boolean layersRequiredLocally) {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.baseImageLayers = this.executorService.submit(() -> this.scheduleCallables(layersRequiredLocally ? ObtainBaseImageLayerStep.makeListForForcedDownload(this.buildConfiguration, childProgressDispatcherFactory, (PullBaseImageStep.ImageAndAuthorization)this.results.baseImageAndAuth.get()) : ObtainBaseImageLayerStep.makeListForSelectiveDownload(this.buildConfiguration, childProgressDispatcherFactory, (PullBaseImageStep.ImageAndAuthorization)this.results.baseImageAndAuth.get(), ((Optional)this.results.pushAuthorization.get()).orElse(null))));
    }

    private void pushBaseImageLayers() {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.baseImageLayerPushResults = this.executorService.submit(() -> this.scheduleCallables(PushLayerStep.makeList(this.buildConfiguration, childProgressDispatcherFactory, ((Optional)this.results.pushAuthorization.get()).orElse(null), (List)this.results.baseImageLayers.get())));
    }

    private void buildAndCacheApplicationLayers() {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.applicationLayers = this.scheduleCallables(BuildAndCacheApplicationLayerStep.makeList(this.buildConfiguration, childProgressDispatcherFactory));
    }

    private void buildImage() {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.builtImage = this.executorService.submit(() -> new BuildImageStep(this.buildConfiguration, childProgressDispatcherFactory, ((PullBaseImageStep.ImageAndAuthorization)this.results.baseImageAndAuth.get()).getImage(), StepsRunner.realizeFutures((List)this.results.baseImageLayers.get()), StepsRunner.realizeFutures((List)Verify.verifyNotNull((Object)this.results.applicationLayers))).call());
    }

    private void pushContainerConfiguration() {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.containerConfigurationPushResult = this.executorService.submit(() -> new PushContainerConfigurationStep(this.buildConfiguration, childProgressDispatcherFactory, ((Optional)this.results.pushAuthorization.get()).orElse(null), (Image)this.results.builtImage.get()).call());
    }

    private void pushApplicationLayers() {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.applicationLayerPushResults = this.executorService.submit(() -> this.scheduleCallables(PushLayerStep.makeList(this.buildConfiguration, childProgressDispatcherFactory, ((Optional)this.results.pushAuthorization.get()).orElse(null), (List)Verify.verifyNotNull((Object)this.results.applicationLayers))));
    }

    private void pushImages() {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.buildResult = this.executorService.submit(() -> {
            StepsRunner.realizeFutures((List)this.results.baseImageLayerPushResults.get());
            StepsRunner.realizeFutures((List)this.results.applicationLayerPushResults.get());
            List manifestPushResults = this.scheduleCallables(PushImageStep.makeList(this.buildConfiguration, childProgressDispatcherFactory, ((Optional)this.results.pushAuthorization.get()).orElse(null), (BlobDescriptor)this.results.containerConfigurationPushResult.get(), (Image)this.results.builtImage.get()));
            StepsRunner.realizeFutures(manifestPushResults);
            return (BuildResult)manifestPushResults.get(0).get();
        });
    }

    private void loadDocker(DockerClient dockerClient) {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.buildResult = this.executorService.submit(() -> new LoadDockerStep(this.buildConfiguration, childProgressDispatcherFactory, dockerClient, (Image)this.results.builtImage.get()).call());
    }

    private void writeTarFile(Path outputPath) {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.buildResult = this.executorService.submit(() -> new WriteTarFileStep(this.buildConfiguration, childProgressDispatcherFactory, outputPath, (Image)this.results.builtImage.get()).call());
    }

    private <E> List<Future<E>> scheduleCallables(ImmutableList<? extends Callable<E>> callables) {
        return callables.stream().map(this.executorService::submit).collect(Collectors.toList());
    }

    private static class StepResults {
        private Future<PullBaseImageStep.ImageAndAuthorization> baseImageAndAuth = StepResults.failedFuture();
        private Future<List<Future<PreparedLayer>>> baseImageLayers = StepResults.failedFuture();
        @Nullable
        private List<Future<PreparedLayer>> applicationLayers;
        private Future<Image> builtImage = StepResults.failedFuture();
        private Future<Optional<Credential>> targetRegistryCredentials = StepResults.failedFuture();
        private Future<Optional<Authorization>> pushAuthorization = StepResults.failedFuture();
        private Future<List<Future<BlobDescriptor>>> baseImageLayerPushResults = StepResults.failedFuture();
        private Future<List<Future<BlobDescriptor>>> applicationLayerPushResults = StepResults.failedFuture();
        private Future<BlobDescriptor> containerConfigurationPushResult = StepResults.failedFuture();
        private Future<BuildResult> buildResult = StepResults.failedFuture();

        private StepResults() {
        }

        private static <E> Future<E> failedFuture() {
            return Futures.immediateFailedFuture((Throwable)new IllegalStateException("invalid usage; required step not configured"));
        }

        static /* synthetic */ Future access$100(StepResults x0) {
            return x0.buildResult;
        }
    }
}

